package cn.dong144.mpgen.util;

import java.util.Date;

/**
 * 名称工具
 *
 * @author haidong
 */
public class NameUtil {
    /**
     * 驼峰转下划线
     * @param str
     * @return
     */
    public static String humpToUnderline(String str){
        StringBuffer buffer = new StringBuffer();
        for (int i = 0 ; i < str.length(); i++){
            char c = str.charAt(i);
            if(Character.isUpperCase(c)){
                buffer.append("_" + Character.toLowerCase(c));
            } else {
                buffer.append(c);
            }
        }
        return buffer.toString();
    }

    /**
     * 下划线转驼峰
     * @param str
     * @param firstUpper 首字母大写
     * @return
     */
    public static String underlineToHump(String str, boolean firstUpper){
        StringBuffer buffer = new StringBuffer();
        boolean findUnderline = false;
        for (int i = 0 ; i < str.length(); i++){
            char c = str.charAt(i);
            if(c == '_'){
                findUnderline = true;
            } else {
                if(findUnderline){
                    buffer.append(Character.toUpperCase(c));
                    findUnderline = false;
                } else if(firstUpper && i == 0){
                    buffer.append(Character.toUpperCase(c));
                } else {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    public static Class dbTypeToJavaType(String dbType){
        switch (dbType){
            case "int":
                return Integer.class;
            case "varchar":
                return String.class;
            case "datetime":
                return Date.class;
        }
        return Object.class;
    }
}
