package cn.dong144.mpgen.mojo;

import cn.dong144.mpgen.generator.impl.MybatisPlusGenerator;
import cn.hutool.setting.Setting;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

/**
 * @author haidong
 */
@Mojo(name = "mpgen")
public class MainMojo extends AbstractMojo {
    @Parameter
    private String projectPath;
    @Parameter
    private String dbUrl;
    @Parameter
    private String username;
    @Parameter
    private String password;
    @Parameter
    private String database;
    @Parameter
    private String genTables;
    @Parameter
    private String codePath;
    @Parameter
    private String packageName;
    @Parameter
    private String xmlPath;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        getLog().info("begin gen");
        getLog().info("projectPath====" + projectPath);
        Setting setting = new Setting();
        setting.put("projectPath", projectPath);
        setting.put("dbUrl", dbUrl);
        setting.put("username", username);
        setting.put("password", password);
        setting.put("database", database);
        setting.put("genTables", genTables);
        setting.put("codePath", codePath);
        setting.put("packageName", packageName);
        setting.put("xmlPath", xmlPath);
        new MybatisPlusGenerator(setting).execute();
        getLog().info("end gen");
    }
}
