/*
 * Decompiled with CFR 0.152.
 */
package cn.dong144.mpgen.generator.impl;

import cn.dong144.mpgen.common.Column;
import cn.dong144.mpgen.common.Package;
import cn.dong144.mpgen.common.Table;
import cn.dong144.mpgen.generator.Generator;
import cn.dong144.mpgen.util.NameUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.db.ds.DSFactory;
import cn.hutool.db.handler.EntityListHandler;
import cn.hutool.db.handler.RsHandler;
import cn.hutool.db.sql.SqlExecutor;
import cn.hutool.extra.template.Template;
import cn.hutool.extra.template.TemplateConfig;
import cn.hutool.extra.template.TemplateEngine;
import cn.hutool.extra.template.TemplateUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.setting.Setting;
import java.io.File;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MybatisPlusGenerator
implements Generator {
    private static final Logger logger = LoggerFactory.getLogger(MybatisPlusGenerator.class);
    private Setting setting;
    private DataSource ds;
    private TemplateEngine engine;
    private String projectPath;

    public MybatisPlusGenerator(String projectPath) {
        this.projectPath = projectPath;
        this.setting = new Setting("conf.setting");
        this.ds = DSFactory.get();
        this.engine = TemplateUtil.createEngine((TemplateConfig)new TemplateConfig("templates", TemplateConfig.ResourceMode.CLASSPATH));
    }

    @Override
    public void execute() {
        String genTables = this.setting.get((Object)"gen_tables");
        List genTableNames = JSONUtil.parseArray((String)genTables).toList(String.class);
        if (CollectionUtil.isNotEmpty((Collection)genTableNames)) {
            this.queryColumns(genTableNames);
        } else {
            this.genAllTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void genAllTable() {
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            List tables = (List)SqlExecutor.query((Connection)conn, (String)"show tables", (RsHandler)new EntityListHandler(), (Object[])new Object[0]);
            List<String> tableNames = tables.stream().map(entity -> {
                Set names = entity.getFieldNames();
                String[] nameList = names.toArray(new String[names.size()]);
                return entity.getStr(nameList[0]);
            }).collect(Collectors.toList());
            logger.info("tables====={}", (Object)JSONUtil.toJsonStr((Object)tables));
            this.queryColumns(tableNames);
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void queryColumns(List<String> tables) {
        String database = this.setting.get((Object)"database");
        Connection conn = null;
        try {
            conn = this.ds.getConnection();
            for (String table : tables) {
                List columns = (List)SqlExecutor.query((Connection)conn, (String)"select COLUMN_NAME from information_schema.COLUMNS where table_name = ? and TABLE_SCHEMA = ?", (RsHandler)new EntityListHandler(), (Object[])new Object[]{table, database});
                logger.info("table={}===columns====={}", (Object)table, (Object)JSONUtil.toJsonStr((Object)columns));
                List<String> colStrList = columns.stream().map(entity -> entity.getStr("COLUMN_NAME")).collect(Collectors.toList());
                this.parseTable(table, colStrList);
            }
            logger.info("\u6267\u884c\u5b8c\u6210===========================");
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void parseTable(String tableName, List<String> columns) {
        Table table = new Table();
        table.setTableName(tableName);
        table.setEntityName(NameUtil.underlineToHump(tableName, true));
        if (CollectionUtil.isNotEmpty(columns)) {
            List<Column> list = columns.stream().filter(str -> !"id".equals(str)).map(str -> {
                Column col = new Column();
                col.setDbName((String)str);
                col.setJavaName(NameUtil.underlineToHump(str, false));
                return col;
            }).collect(Collectors.toList());
            table.setColumns(list);
        }
        this.genFile(table);
    }

    private void genFile(Table table) {
        String codePath = this.setting.get((Object)"code_path");
        String xmlPath = this.setting.get((Object)"xml_path");
        Package pack = new Package(this.setting.get((Object)"package"));
        HashMap<String, Table> context = new HashMap<String, Table>();
        context.putAll((Map<String, Table>)this.setting);
        context.put("table", table);
        File xmlPathFile = new File(this.projectPath, xmlPath);
        File codePathFile = new File(this.projectPath, codePath);
        File packageFile = new File(codePathFile, pack.getPath());
        File entityFile = new File(packageFile, "entity");
        File daoFile = new File(packageFile, "mapper");
        File xmlFile = new File(xmlPathFile, "mapper");
        Template entityTemplate = this.engine.getTemplate("entity.ftl");
        entityTemplate.render(context, new File(entityFile, table.getEntityName() + ".java"));
        logger.info("\u751f\u6210" + table.getEntityName() + ".java\u6587\u4ef6===========");
        Template xmlTemplate = this.engine.getTemplate("mapper.ftl");
        xmlTemplate.render(context, new File(xmlFile, table.getEntityName() + "Mapper.xml"));
        logger.info("\u751f\u6210" + table.getEntityName() + "Mapper.xml\u6587\u4ef6===========");
        Template mapperTemplate = this.engine.getTemplate("dao.ftl");
        mapperTemplate.render(context, new File(daoFile, table.getEntityName() + "Mapper.java"));
        logger.info("\u751f\u6210" + table.getEntityName() + "Mapper.java\u6587\u4ef6===========");
    }
}

