/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.sql.dialect;

import cn.dinodev.spring.commons.utils.NamingUtils;
import cn.dinodev.spring.data.sql.dialect.NamingConversition;
import java.util.Map;
import java.util.WeakHashMap;

public class SnakeNamingConversition
implements NamingConversition {
    private static final Map<String, String> NAMING_CACHE = new WeakHashMap<String, String>(1000);

    @Override
    public String convertColumnName(String colName) {
        String val = NAMING_CACHE.get(colName);
        if (val == null) {
            val = NamingUtils.toSnake((String)colName);
            NAMING_CACHE.put(colName, val);
        }
        return val;
    }

    @Override
    public String convertTableName(String tableName) {
        return this.convertColumnName(tableName);
    }
}

