/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.sql.dialect;

import cn.dinodev.spring.data.sql.dialect.Dialect;
import cn.dinodev.spring.data.sql.dialect.NamingConversition;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class PostgreSQLDialect
implements Dialect {
    private final NamingConversition namingConversition;
    private final String uuidSql;

    public PostgreSQLDialect(DatabaseMetaData metaData, NamingConversition namingConversition) throws SQLException {
        this.namingConversition = namingConversition;
        int majorVer = metaData.getDatabaseMajorVersion();
        this.uuidSql = majorVer >= 13 ? "SELECT gen_random_uuid()" : "SELECT uuid_generate_v4()";
    }

    @Override
    public NamingConversition namingConversition() {
        return this.namingConversition;
    }

    @Override
    public String limitOffset(int limit, long offset) {
        if (limit > 0) {
            return offset > 0L ? "LIMIT " + limit + " OFFSET " + offset : "LIMIT " + limit;
        }
        return "";
    }

    @Override
    public String getSelectUUIDSql() {
        return this.uuidSql;
    }

    @Override
    public String quoteTableName(String name) {
        return StringUtils.wrapIfMissing((String)name, (char)'\"');
    }

    @Override
    public String getSequenceNextValSql(String sequenceName) {
        return "SELECT nextval('" + sequenceName + "')";
    }

    @Override
    public boolean supportSequence() {
        return true;
    }

    @Override
    public boolean supportUUID() {
        return true;
    }
}

