/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.sql.dialect;

import cn.dinodev.spring.data.sql.dialect.NamingConversition;
import org.apache.commons.lang3.StringUtils;

public interface Dialect {
    public NamingConversition namingConversition();

    public String limitOffset(int var1, long var2);

    public boolean supportUUID();

    public String getSelectUUIDSql();

    public String getSequenceNextValSql(String var1);

    public boolean supportSequence();

    public String quoteTableName(String var1);

    public static Dialect ofDefault() {
        return Default.INST_DEFAULT;
    }

    public static class Default
    implements Dialect {
        private static final Default INST_DEFAULT = new Default();

        @Override
        public String limitOffset(int limit, long offset) {
            if (limit > 0) {
                return offset > 0L ? "LIMIT " + limit + " OFFSET " + offset : "LIMIT " + limit;
            }
            return "";
        }

        @Override
        public String getSelectUUIDSql() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSequenceNextValSql(String sequenceName) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean supportSequence() {
            return false;
        }

        @Override
        public String quoteTableName(String name) {
            return StringUtils.wrapIfMissing((String)name, (char)'\"');
        }

        @Override
        public NamingConversition namingConversition() {
            return NamingConversition.Default.INST;
        }

        @Override
        public boolean supportUUID() {
            return false;
        }
    }
}

