/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.sql.builder;

import cn.dinodev.spring.commons.data.Range;
import cn.dinodev.spring.data.sql.Logic;
import cn.dinodev.spring.data.sql.Oper;
import cn.dinodev.spring.data.sql.SqlBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class WhereSql<T extends SqlBuilder>
implements SqlBuilder {
    protected static final Object[] EMPTY_PARAMS = new Object[0];
    protected List<String> tables = new ArrayList<String>();
    protected List<String> whereColumns = new ArrayList<String>();
    protected List<Object> whereParams = new ArrayList<Object>();
    protected SqlBuilder withSql = null;
    protected String withName = null;
    private T that;

    protected void setThat(T that) {
        this.that = that;
    }

    public T table(String ... tables) {
        if (tables != null) {
            this.tables.addAll(Arrays.asList(tables));
        }
        return this.that;
    }

    public T with(SqlBuilder subQuery, String alias) {
        this.withName = alias;
        this.withSql = subQuery;
        this.table(alias);
        return this.that;
    }

    public T where(String expr) {
        return this.and(expr);
    }

    public T where(String expr, Object ... values) {
        this.appendWhere(Logic.AND, expr);
        this.whereParams.addAll(Arrays.asList(values));
        return this.that;
    }

    public T where(String column, Oper op, Object value) {
        this.where(op.makeExpr(column));
        this.whereParams.add(value);
        return this.that;
    }

    public T whereIfNotNull(String expr, Object value) {
        if (value == null) {
            return this.that;
        }
        this.where(expr, value);
        return this.that;
    }

    public T whereIfNotNull(String column, Oper op, Object value) {
        if (!Objects.isNull(value)) {
            this.where(column, op, value);
        }
        return this.that;
    }

    public T whereIf(boolean cnd, String expr, Object ... values) {
        if (!cnd) {
            return this.that;
        }
        return this.where(expr, values);
    }

    public T whereIf(boolean cnd, String column, Oper op, Object value) {
        if (!cnd) {
            return this.that;
        }
        return this.where(column, op, value);
    }

    public T and(String expr) {
        this.appendWhere(Logic.AND, expr);
        return this.that;
    }

    public T and(String expr, Object ... values) {
        this.and(expr);
        this.whereParams.addAll(Arrays.asList(values));
        return this.that;
    }

    public T and(String column, Oper op, Object value) {
        return this.and(String.format("%s %s ?", column, op.getOp()), value);
    }

    public T andIf(boolean cnd, String expr, Object ... values) {
        if (!cnd) {
            return this.that;
        }
        return this.and(expr, values);
    }

    public T andIf(boolean cnd, String column, Oper op, Object value) {
        if (!cnd) {
            return this.that;
        }
        return this.and(column, op, value);
    }

    public T andIfNotNull(String expr, Object value) {
        return this.andIf(!Objects.isNull(value), expr, value);
    }

    public T andIfNotNull(String column, Oper op, Object value) {
        return this.andIf(!Objects.isNull(value), column, op, value);
    }

    public T eq(String column, Object value) {
        return this.and(String.format("%s = ?", column), value);
    }

    public T eqIf(boolean cnd, String column, Object value) {
        return this.andIf(cnd, column, Oper.EQ, value);
    }

    public T eqIfNotNull(String column, Object value) {
        return this.andIf(!Objects.isNull(value), column, Oper.EQ, value);
    }

    public T eqIfNotBlank(String column, String value) {
        return this.andIf(StringUtils.isNotBlank((CharSequence)value), column, Oper.EQ, (Object)value);
    }

    public T ne(String column, Object value) {
        return this.and(String.format("%s != ?", column), value);
    }

    public T neIf(boolean cnd, String column, Object value) {
        return this.andIf(cnd, column, Oper.NE, value);
    }

    public T neIfNotNull(String column, Object value) {
        return this.andIf(!Objects.isNull(value), column, Oper.NE, value);
    }

    public T neIfNotBlank(String column, String value) {
        return this.andIf(StringUtils.isNotBlank((CharSequence)value), column, Oper.NE, (Object)value);
    }

    public T or(String expr) {
        this.appendWhere(Logic.OR, expr);
        return this.that;
    }

    public T or(String expr, Object ... values) {
        this.or(expr);
        this.whereParams.addAll(Arrays.asList(values));
        return this.that;
    }

    public T or(String column, Oper op, Object value) {
        this.or(op.makeExpr(column));
        this.whereParams.add(value);
        return this.that;
    }

    public T orIf(boolean cnd, String expr, Object ... values) {
        if (!cnd) {
            return this.that;
        }
        return this.or(expr, values);
    }

    public T orIf(boolean cnd, String column, Oper op, Object value) {
        if (!cnd) {
            return this.that;
        }
        return this.or(column, op, value);
    }

    public T orIfNotNull(String expr, Object value) {
        return this.orIf(!Objects.isNull(value), expr, value);
    }

    public T orIfNotNull(String column, Oper op, Object value) {
        return this.orIf(!Objects.isNull(value), column, op, value);
    }

    public T between(String column, Number start, Number end) {
        if (!Objects.isNull(start)) {
            this.and(column, Oper.GTE, (Object)start);
        }
        if (!Objects.isNull(end)) {
            this.and(column, Oper.LTE, (Object)end);
        }
        return this.that;
    }

    public T between(String column, Range<?> range) {
        if (!Objects.isNull(range.getBegin())) {
            this.and(column, Oper.GTE, (Object)range.getBegin());
        }
        if (!Objects.isNull(range.getEnd())) {
            this.and(column, Oper.LTE, (Object)range.getEnd());
        }
        return this.that;
    }

    public T any(String column, T subQuery) {
        return this.any(column, subQuery, Logic.AND);
    }

    public T any(String column, T subQuery, Logic logic) {
        this.appendWhere(logic, String.format("%s = any(%s)", column, subQuery.getSql()));
        this.whereParams.addAll(Arrays.asList(subQuery.getParams()));
        return this.that;
    }

    public T some(String[] columns, Oper op, Object value, Logic logic) {
        if (Objects.isNull(value)) {
            if (op == Oper.EQ) {
                this.appendNColumnExpr(logic, columns, Oper.IS_NULL, null, Logic.OR);
            } else if (op == Oper.NE) {
                this.appendNColumnExpr(logic, columns, Oper.IS_NOT_NULL, null, Logic.OR);
            }
        } else {
            this.appendNColumnExpr(logic, columns, op, value, Logic.OR);
        }
        return this.that;
    }

    public T some(String[] columns, Oper op, Object value) {
        return this.some(columns, op, value, Logic.AND);
    }

    public T someIf(boolean cnd, String[] columns, Oper op, Object value, Logic logic) {
        if (cnd) {
            this.appendNColumnExpr(logic, columns, op, value, Logic.OR);
        }
        return this.that;
    }

    public T someIf(boolean cnd, String[] columns, Oper op, String value) {
        if (!cnd) {
            return this.that;
        }
        return this.some(columns, op, value, Logic.AND);
    }

    public T in(String column, Collection<?> values) {
        return this.in(column, values, Logic.AND);
    }

    public T inIf(boolean cnd, String column, Collection<?> values) {
        return cnd ? this.in(column, values, Logic.AND) : this.that;
    }

    public T in(String column, Collection<?> values, Logic logic) {
        if (values == null || values.isEmpty()) {
            return this.that;
        }
        if (values.size() == 1) {
            this.appendWhere(logic, column + " = ?");
        } else {
            this.appendWhere(logic, this.makeINExpr(column, "IN", values.size()));
        }
        this.whereParams.addAll(values);
        return this.that;
    }

    public T in(String column, Object[] values) {
        return this.in(column, values, Logic.AND);
    }

    public T inIf(boolean cnd, String column, Object[] values) {
        return cnd ? this.in(column, values, Logic.AND) : this.that;
    }

    public T in(String column, Object[] values, Logic logic) {
        if (values == null || values.length == 0) {
            return this.that;
        }
        return this.in(column, Arrays.asList(values), logic);
    }

    public T notIn(String column, Collection<?> values) {
        return this.notIn(column, values, Logic.AND);
    }

    public T notIn(String column, Collection<?> values, Logic logic) {
        if (values == null || values.isEmpty()) {
            return this.that;
        }
        if (values.size() == 1) {
            this.appendWhere(logic, Oper.NE.makeExpr(column));
        } else {
            this.appendWhere(logic, this.makeINExpr(column, "NOT IN", values.size()));
        }
        this.whereParams.addAll(values);
        return this.that;
    }

    public T notIn(String column, Object[] values) {
        return this.notIn(column, values, Logic.AND);
    }

    public T notIn(String column, Object[] values, Logic logic) {
        if (values == null || values.length == 0) {
            return this.that;
        }
        if (values.length == 1) {
            this.appendWhere(logic, Oper.NE.makeExpr(column));
        } else {
            this.appendWhere(logic, this.makeINExpr(column, "NOT IN", values.length));
        }
        this.whereParams.addAll(Arrays.asList(values));
        return this.that;
    }

    public T isNull(String column) {
        return this.isNull(column, Logic.AND);
    }

    public T isNull(String column, Logic logic) {
        this.appendWhere(logic, Oper.IS_NULL.makeExpr(column));
        return this.that;
    }

    public T isNullIf(boolean cnd, String column) {
        if (!cnd) {
            return this.that;
        }
        return this.isNull(column, Logic.AND);
    }

    public T isNullIf(boolean cnd, String column, Logic logic) {
        if (!cnd) {
            return this.that;
        }
        this.appendWhere(logic, Oper.IS_NULL.makeExpr(column));
        return this.that;
    }

    public T isNotNull(String column) {
        return this.isNotNull(column, Logic.AND);
    }

    public T isNotNull(String column, Logic logic) {
        this.appendWhere(logic, Oper.IS_NOT_NULL.makeExpr(column));
        return this.that;
    }

    public T isNotNullIf(boolean cnd, String column) {
        if (!cnd) {
            return this.that;
        }
        return this.isNotNull(column, Logic.AND);
    }

    public T isNotNullIf(boolean cnd, String column, Logic logic) {
        if (!cnd) {
            return this.that;
        }
        this.appendWhere(logic, Oper.IS_NOT_NULL.makeExpr(column));
        return this.that;
    }

    public T like(String column, String value) {
        return this.like(column, value, Logic.AND);
    }

    public T like(String column, String value, Logic logic) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.appendOrTrue(logic);
            return this.that;
        }
        this.appendWhere(logic, column + " like ?");
        this.whereParams.add("%" + value + "%");
        return this.that;
    }

    public T someLike(String[] columns, String value, Logic logic) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.appendOrTrue(logic);
            return this.that;
        }
        this.appendNColumnExpr(logic, columns, Oper.LIKE, "%" + value + "%", Logic.OR);
        return this.that;
    }

    public T someLike(String[] columns, String value) {
        return this.someLike(columns, value, Logic.AND);
    }

    public T startWith(String column, String value) {
        return this.startWith(column, value, Logic.AND);
    }

    public T startWith(String column, String value, Logic logic) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.appendOrTrue(logic);
            return this.that;
        }
        this.appendWhere(logic, column + " like ?");
        this.whereParams.add(value + "%");
        return this.that;
    }

    public T someStartWith(String[] columns, String value, Logic logic) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.appendOrTrue(logic);
            return this.that;
        }
        this.appendNColumnExpr(logic, columns, Oper.LIKE, value + "%", Logic.OR);
        return this.that;
    }

    public T someStartWith(String[] columns, String value) {
        return this.someStartWith(columns, value, Logic.AND);
    }

    public T endWith(String column, String value) {
        return this.endWith(column, value, Logic.AND);
    }

    public T endWith(String column, String value, Logic logic) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.appendOrTrue(logic);
            return this.that;
        }
        this.appendWhere(logic, column + " like ?");
        this.whereParams.add("%" + value);
        return this.that;
    }

    public T someEndWith(String[] columns, String value, Logic logic) {
        if (StringUtils.isBlank((CharSequence)value)) {
            this.appendOrTrue(logic);
            return this.that;
        }
        this.appendNColumnExpr(logic, columns, Oper.LIKE, "%" + value, Logic.OR);
        return this.that;
    }

    public T someEndWith(String[] columns, String value) {
        return this.someEndWith(columns, value, Logic.AND);
    }

    private void appendWhere(Logic logicOp, String expr) {
        if (this.whereColumns.isEmpty()) {
            this.whereColumns.add(expr);
        } else {
            this.whereColumns.add(String.format("%s (%s)", logicOp.getLogic(), expr));
        }
    }

    private void appendOrTrue(Logic logicOp) {
        if (logicOp == Logic.OR) {
            this.appendWhere(Logic.OR, "1=1");
        }
    }

    private void appendNColumnExpr(Logic logicOp, String[] columns, Oper op, Object value, Logic innerLogic) {
        Collector<CharSequence, ?, String> joiner = Collectors.joining(StringUtils.wrap((String)innerLogic.getLogic(), (char)' '), "(", ")");
        String expr = Arrays.stream(columns).map(xva$0 -> op.makeExpr((String)xva$0)).collect(joiner);
        this.appendWhere(logicOp, expr);
        if (op.hasValue()) {
            for (int i = 0; i < columns.length; ++i) {
                this.whereParams.add(value);
            }
        }
    }

    private String makeINExpr(String column, String op, int nCount) {
        StringBuilder expr = new StringBuilder();
        int idx = 0;
        expr.append(column).append(" ").append(op).append(" (");
        while (idx < nCount) {
            if (idx++ != 0) {
                expr.append(", ");
            }
            expr.append('?');
        }
        expr.append(')');
        return expr.toString();
    }
}

