/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.sql.builder;

import cn.dinodev.spring.data.sql.builder.WhereSql;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class UpdateSqlBuilder
extends WhereSql<UpdateSqlBuilder> {
    protected List<String> updateColumns = new ArrayList<String>();
    protected List<Object> updateParams = new ArrayList<Object>();

    public UpdateSqlBuilder(String table) {
        this.setThat(this);
        this.table(table);
    }

    public UpdateSqlBuilder(String table, String alias) {
        this.setThat(this);
        this.table(table + " AS " + alias);
    }

    public UpdateSqlBuilder set(String expr, Object value) {
        if (StringUtils.contains((CharSequence)expr, (int)63)) {
            this.updateColumns.add(expr);
        } else {
            this.updateColumns.add(expr + "=?");
        }
        this.updateParams.add(value);
        return this;
    }

    public UpdateSqlBuilder setIf(boolean cnd, String expr, Object value) {
        if (cnd) {
            return this.set(expr, value);
        }
        return this;
    }

    public UpdateSqlBuilder setIfNotNull(String expr, Object value) {
        return this.setIf(!Objects.isNull(value), expr, value);
    }

    public UpdateSqlBuilder set(String expr) {
        this.updateColumns.add(expr);
        return this;
    }

    public UpdateSqlBuilder setIf(boolean cnd, String expr) {
        if (cnd) {
            return this.set(expr);
        }
        return this;
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder(64);
        if (this.withSql != null) {
            sql.append("WITH ").append(this.withName).append(" AS (\n").append(this.withSql.getSql()).append("\n)\n");
        }
        sql.append("UPDATE ");
        this.appendList(sql, this.tables, " ", ", ");
        this.appendList(sql, this.updateColumns, " SET ", ", ");
        this.appendList(sql, this.whereColumns, " WHERE ", " ");
        return sql.toString();
    }

    @Override
    public Object[] getParams() {
        Stream<Object[]> paramsArr = Stream.of(this.withSql == null ? EMPTY_PARAMS : this.withSql.getParams(), this.updateParams.toArray(), this.whereParams.toArray());
        return paramsArr.flatMap(Arrays::stream).toArray();
    }

    public String toString() {
        return this.getSql();
    }
}

