/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.sql.builder;

import cn.dinodev.spring.data.sql.builder.WhereSql;
import cn.dinodev.spring.data.sql.dialect.Dialect;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;

public class SelectSqlBuilder
extends WhereSql<SelectSqlBuilder> {
    protected boolean distinct;
    protected List<String> columns = new ArrayList<String>();
    protected List<JoinEntity<String>> joins = new ArrayList<JoinEntity<String>>();
    protected List<String> groupBys = new ArrayList<String>();
    protected List<String> havings = new ArrayList<String>();
    protected List<JoinEntity<SelectSqlBuilder>> unions = new ArrayList<JoinEntity<SelectSqlBuilder>>();
    protected List<String> orderBys = new ArrayList<String>();
    protected List<Object> havingParams = new ArrayList<Object>();
    protected List<Object> joinParams = new ArrayList<Object>();
    private int limit = 0;
    private long offset = 0L;
    private final Dialect dialect;

    public SelectSqlBuilder(Dialect dialect) {
        this.dialect = dialect;
        this.setThat(this);
    }

    public SelectSqlBuilder(Dialect dialect, String table) {
        this(dialect);
        this.table(table);
    }

    public SelectSqlBuilder(Dialect dialect, String table, String alias) {
        this(dialect);
        this.table(table + " AS " + alias);
    }

    public SelectSqlBuilder(SelectSqlBuilder subQuery, String alias) {
        this(subQuery.dialect);
        this.table(String.format("( %s ) AS %s", subQuery.getSql(), alias));
        this.whereParams.addAll(Arrays.asList(subQuery.getParams()));
    }

    public SelectSqlBuilder column(String name) {
        this.columns.add(name);
        return this;
    }

    public SelectSqlBuilder columns(String ... names) {
        this.columns.addAll(Arrays.asList(names));
        return this;
    }

    public SelectSqlBuilder groupBy(String ... expr) {
        this.groupBys.addAll(Arrays.asList(expr));
        return this;
    }

    public SelectSqlBuilder orderBy(String ... expr) {
        if (expr != null) {
            this.orderBys.addAll(Arrays.asList(expr));
        }
        return this;
    }

    public SelectSqlBuilder orderBy(String name, boolean ascending) {
        if (ascending) {
            this.orderBys.add(name + " ASC");
        } else {
            this.orderBys.add(name + " DESC");
        }
        return this;
    }

    public SelectSqlBuilder having(String expr) {
        this.havings.add(expr);
        return this;
    }

    public SelectSqlBuilder having(String expr, Object ... values) {
        this.having(expr);
        if (values != null) {
            this.havingParams.addAll(Arrays.asList(values));
        }
        return this;
    }

    public SelectSqlBuilder union(SelectSqlBuilder selectSql) {
        this.unions.add(new JoinEntity<SelectSqlBuilder>("\nUNION\n", selectSql));
        return this;
    }

    public SelectSqlBuilder unionAll(SelectSqlBuilder selectSql) {
        this.unions.add(new JoinEntity<SelectSqlBuilder>("\nUNION ALL\n", selectSql));
        return this;
    }

    public SelectSqlBuilder join(String joinExpr) {
        this.joins.add(new JoinEntity<String>("JOIN", joinExpr));
        return this;
    }

    public SelectSqlBuilder join(String table, String alias) {
        return this.join(String.format("%s AS %s", table, alias));
    }

    public SelectSqlBuilder join(String table, String alias, String onExpr, Object ... values) {
        this.join(String.format("%s AS %s ON %s", table, alias, onExpr));
        if (values != null) {
            this.joinParams.addAll(Arrays.asList(values));
        }
        return this;
    }

    public SelectSqlBuilder leftJoin(String joinExpr) {
        this.joins.add(new JoinEntity<String>("LEFT JOIN", joinExpr));
        return this;
    }

    public SelectSqlBuilder leftJoin(String table, String alias) {
        return this.leftJoin(String.format("%s AS %s", table, alias));
    }

    public SelectSqlBuilder leftJoin(String table, String alias, String onExpr, Object ... values) {
        this.leftJoin(String.format("%s AS %s ON %s", table, alias, onExpr));
        if (values != null) {
            this.joinParams.addAll(Arrays.asList(values));
        }
        return this;
    }

    public SelectSqlBuilder rightJoin(String joinExpr) {
        this.joins.add(new JoinEntity<String>("RIGHT JOIN", joinExpr));
        return this;
    }

    public SelectSqlBuilder rightJoin(String table, String alias) {
        return this.rightJoin(String.format("%s AS %s", table, alias));
    }

    public SelectSqlBuilder rightJoin(String table, String alias, String onExpr, Object ... values) {
        this.rightJoin(String.format("%s AS %s ON %s", table, alias, onExpr));
        if (values != null) {
            this.joinParams.addAll(Arrays.asList(values));
        }
        return this;
    }

    public SelectSqlBuilder crossJoin(String joinExpr) {
        this.joins.add(new JoinEntity<String>("CROSS JOIN", joinExpr));
        return this;
    }

    public SelectSqlBuilder crossJoin(String joinExpr, String alias) {
        return this.crossJoin(String.format("%s AS %s", joinExpr, alias));
    }

    public SelectSqlBuilder distinct() {
        this.distinct = true;
        return this;
    }

    public SelectSqlBuilder limit(int limit) {
        return this.limit(limit, 0L);
    }

    public SelectSqlBuilder limit(int limit, long offset) {
        this.limit = limit;
        this.offset = offset;
        return this;
    }

    public String toString() {
        return this.getSql();
    }

    @Override
    public String getSql() {
        return this.getSql(false);
    }

    private String getSql(boolean isCount) {
        StringBuilder sql = new StringBuilder(64);
        if (this.withSql != null) {
            sql.append("WITH ").append(this.withName).append(" AS (\n").append(this.withSql.getSql()).append("\n)\n");
        }
        sql.append("SELECT ");
        this.appendColumn(sql, isCount);
        this.appendList(sql, this.tables, " FROM ", ", ");
        this.appendList(sql, this.joins, " ", " ");
        this.appendList(sql, this.whereColumns, " WHERE ", " ");
        this.appendList(sql, this.groupBys, " GROUP BY ", ", ");
        this.appendList(sql, this.havings, " HAVING ", " AND ");
        this.appendList(sql, this.unions, "  ", " \n ");
        if (isCount) {
            return sql.toString();
        }
        this.appendList(sql, this.orderBys, " ORDER BY ", ", ");
        if (this.limit > 0) {
            sql.append(" ").append(this.dialect.limitOffset(this.limit, this.offset));
        }
        return sql.toString();
    }

    private void appendColumn(StringBuilder sql, boolean isCount) {
        if (this.distinct && !isCount) {
            sql.append("DISTINCT ");
        }
        if (isCount) {
            sql.append("count(1) AS cnt");
        } else if (this.columns.isEmpty()) {
            sql.append("*");
        } else {
            this.appendList(sql, this.columns, "", ", ");
        }
    }

    public String getCountSql() {
        return this.getSql(true);
    }

    @Override
    public Object[] getParams() {
        Stream<Object> paramsArr = Stream.of(this.withSql == null ? EMPTY_PARAMS : this.withSql.getParams(), this.joinParams.toArray(), this.whereParams.toArray(), this.havingParams.toArray());
        paramsArr = Stream.concat(paramsArr, this.unions.stream().map(v -> ((SelectSqlBuilder)v.expr).getParams()));
        return paramsArr.flatMap(Arrays::stream).toArray();
    }

    private static class JoinEntity<V> {
        String op;
        V expr;

        public JoinEntity(String op, V expr) {
            this.op = op;
            this.expr = expr;
        }

        public String toString() {
            return this.op + " " + this.expr.toString();
        }
    }
}

