/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.sql.builder;

import cn.dinodev.spring.data.sql.SqlBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class InsertSqlBuilder
implements SqlBuilder {
    private String table;
    protected List<String> setColumns = new ArrayList<String>();
    protected List<String> valueExps = new ArrayList<String>();
    protected List<Object> setParams = new ArrayList<Object>();

    public InsertSqlBuilder(String table) {
        this.table = table;
    }

    public InsertSqlBuilder set(String col, Object value) {
        return this.set(col, "?", value);
    }

    public InsertSqlBuilder set(String col, String valueExpr, Object value) {
        this.setColumns.add(col);
        this.valueExps.add(valueExpr);
        this.setParams.add(value);
        return this;
    }

    public InsertSqlBuilder setIf(boolean cnd, String col, Object value) {
        return this.setIf(cnd, col, "?", value);
    }

    public InsertSqlBuilder setIf(boolean cnd, String col, String valueExpr, Object value) {
        if (cnd) {
            return this.set(col, valueExpr, value);
        }
        return this;
    }

    public InsertSqlBuilder setIfNotNull(String col, Object value) {
        return this.setIf(!Objects.isNull(value), col, value);
    }

    public InsertSqlBuilder withoutParam(String col, String valueExpr) {
        this.setColumns.add(col);
        this.valueExps.add(valueExpr);
        return this;
    }

    public InsertSqlBuilder withoutParamIf(boolean cnd, String col, String expr) {
        if (cnd) {
            return this.withoutParam(col, expr);
        }
        return this;
    }

    public InsertSqlBuilder setJson(String col, Object value) {
        return this.set(col, "?::json", value);
    }

    public InsertSqlBuilder setJsonIf(boolean cnd, String col, Object value) {
        if (cnd) {
            return this.set(col, "?::json", value);
        }
        return this;
    }

    public InsertSqlBuilder setJsonIfNotNull(String col, Object value) {
        return this.setJsonIf(!Objects.isNull(value), col, value);
    }

    public InsertSqlBuilder setJsonb(String col, Object value) {
        return this.set(col, "?::jsonb", value);
    }

    public InsertSqlBuilder setJsonbIf(boolean cnd, String col, Object value) {
        if (cnd) {
            return this.set(col, "?::jsonb", value);
        }
        return this;
    }

    public InsertSqlBuilder setJsonbIfNotNull(String col, Object value) {
        return this.setJsonIf(!Objects.isNull(value), col, value);
    }

    @Override
    public String getSql() {
        StringBuilder sql = new StringBuilder(64);
        sql.append("INSERT INTO ").append(this.table);
        this.appendList(sql, this.setColumns, " (", ", ", ") ");
        this.appendList(sql, this.valueExps, " VALUES(", ", ", ") ");
        return sql.toString();
    }

    @Override
    public Object[] getParams() {
        return this.setParams.toArray(new Object[this.setParams.size()]);
    }
}

