/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.sql;

import org.apache.commons.lang3.StringUtils;

public enum Oper {
    EQ("=", "%s = ?"),
    GT(">", "%s > ?"),
    LT("<", "%s < ?"),
    NE("<>", "%s <> ?"),
    GTE(">=", "%s >= ?"),
    LTE("<=", "%s <= ?"),
    LIKE("LIKE", "%s LIKE ?"),
    NOT_LIKE("NOT LIKE", "%s NOT LIKE ?"),
    IN("IN", "%s IN (%s)"),
    NOT_IN("NOT IN", "%s NOT IN (%s)"),
    IS_NULL("IS NULL", "%s IS NULL"),
    IS_NOT_NULL("IS NOT NULL", "%s IS NOT NULL"),
    BETWEEN("BETWEEN", "%s BETWEEN ? AND ?"),
    EXISTS("EXISTS", "EXISTS (%s)");

    private final String op;
    private final String expr;
    private final int paramCount;
    private final int valueCount;

    private Oper(String op, String expr) {
        this.op = op;
        this.expr = expr;
        this.paramCount = StringUtils.countMatches((CharSequence)expr, (char)'%');
        this.valueCount = StringUtils.countMatches((CharSequence)expr, (char)'?');
    }

    public String getOp() {
        return this.op;
    }

    public String makeExpr(String ... params) {
        if (params.length != this.paramCount) {
            throw new IllegalArgumentException(this.op + " need " + this.paramCount + " param(s), actule is " + params.length);
        }
        return String.format(this.expr, params);
    }

    public boolean hasValue() {
        return this.valueCount > 0;
    }

    public String toString() {
        return this.op;
    }
}

