/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.jdbc.mapping;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.data.convert.PropertyValueConverter;
import org.springframework.data.convert.ValueConversionContext;
import org.springframework.data.util.CastUtils;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;

public class JsonbPropertyValueConverter
implements PropertyValueConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonbPropertyValueConverter.class);
    @Autowired
    private ObjectMapper objectMapper;

    public Object read(@NonNull Object value, @NonNull ValueConversionContext context) {
        PGobject sourceData = (PGobject)CastUtils.cast((Object)value);
        TypeDescriptor targetType = TypeDescriptor.valueOf((Class)context.getProperty().getType());
        try {
            if (targetType.isCollection()) {
                return this.convertCollection(sourceData, targetType);
            }
            if (targetType.isArray()) {
                return this.convertArray(sourceData, targetType);
            }
            if (targetType.isMap()) {
                return this.convertMap(sourceData, targetType);
            }
            return this.convertObject(sourceData, targetType);
        }
        catch (JsonProcessingException e) {
            log.error("convert error  to:{} value:{}", new Object[]{targetType, value, e});
            throw new ConversionFailedException(TypeDescriptor.forObject((Object)value), targetType, value, (Throwable)e);
        }
    }

    public Object write(@Nullable Object value, @NonNull ValueConversionContext context) {
        PGobject pg = new PGobject();
        pg.setType("jsonb");
        try {
            if (Objects.isNull(value)) {
                pg.setValue(null);
            }
            pg.setValue(this.objectMapper.writeValueAsString(value));
            return pg;
        }
        catch (JsonProcessingException | SQLException e) {
            log.error("convert write value:{}", value, (Object)e);
            throw new ConversionFailedException(TypeDescriptor.forObject((Object)value), TypeDescriptor.valueOf(PGobject.class), value, e);
        }
    }

    private Object convertCollection(PGobject source, TypeDescriptor targetType) throws JsonProcessingException {
        if (source == null || source.getValue() == null || StringUtils.isBlank((CharSequence)source.getValue())) {
            return Collections.emptyList();
        }
        return this.objectMapper.readerForListOf(targetType.getResolvableType().getGeneric(new int[]{0}).getRawClass()).readValue(source.getValue());
    }

    private Object convertArray(PGobject source, TypeDescriptor targetType) throws JsonProcessingException {
        if (source == null || source.getValue() == null || StringUtils.isBlank((CharSequence)source.getValue())) {
            return null;
        }
        return this.objectMapper.readerForArrayOf(targetType.getResolvableType().getComponentType().getRawClass()).readValue(source.getValue());
    }

    private Object convertMap(PGobject source, TypeDescriptor targetType) throws JsonProcessingException {
        if (source == null || source.getValue() == null || StringUtils.isBlank((CharSequence)source.getValue())) {
            return Collections.emptyMap();
        }
        TypeDescriptor mapValueTypeDescriptor = targetType.getMapValueTypeDescriptor();
        if (mapValueTypeDescriptor == null) {
            return Collections.emptyMap();
        }
        return this.objectMapper.readerForMapOf(mapValueTypeDescriptor.getResolvableType().getRawClass()).readValue(source.getValue());
    }

    private Object convertObject(PGobject source, TypeDescriptor targetType) throws JsonProcessingException {
        if (source == null || source.getValue() == null) {
            return null;
        }
        Class cls = targetType.getResolvableType().getRawClass();
        if (cls == null) {
            cls = targetType.getType();
        }
        return this.objectMapper.readerFor(cls).readValue(source.getValue());
    }
}

