/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.jdbc.mapping;

import jakarta.persistence.Column;
import jakarta.persistence.Embedded;
import jakarta.persistence.Id;
import jakarta.persistence.Transient;
import jakarta.persistence.Version;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.jdbc.core.mapping.BasicJdbcPersistentProperty;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.Lazy;
import org.springframework.lang.NonNull;

public class DinoJdbcPersistentProperty
extends BasicJdbcPersistentProperty {
    private final Lazy<Boolean> isId = Lazy.of(() -> this.isAnnotationPresent(Id.class) || super.isIdProperty());
    private final Lazy<Boolean> isVersion = Lazy.of(() -> this.isAnnotationPresent(Version.class) || super.isVersionProperty());
    private final Lazy<Boolean> isEmbedded = Lazy.of(() -> this.isAnnotationPresent(Embedded.class) || super.isEmbedded());
    private final Lazy<SqlIdentifier> columnName = Lazy.of(() -> Optional.ofNullable((Column)this.findAnnotation(Column.class)).map(Column::name).filter(StringUtils::isNotBlank).map(this::createSqlIdentifier).orElseGet(() -> super.getColumnName()));
    private final Lazy<Boolean> isInsertable = Lazy.of(() -> Optional.ofNullable((Column)this.findAnnotation(Column.class)).map(Column::insertable).orElse(true));
    private final Lazy<Boolean> isUpdatable = Lazy.of(() -> Optional.ofNullable((Column)this.findAnnotation(Column.class)).map(Column::updatable).orElseGet(() -> !super.isInsertOnly()));
    private final Lazy<Boolean> isTransient = Lazy.of(() -> this.isAnnotationPresent(Transient.class) || super.isTransient());

    public DinoJdbcPersistentProperty(Property property, PersistentEntity<?, RelationalPersistentProperty> owner, SimpleTypeHolder simpleTypeHolder, NamingStrategy namingStrategy) {
        super(property, owner, simpleTypeHolder, namingStrategy);
    }

    public boolean isIdProperty() {
        return (Boolean)this.isId.get();
    }

    public boolean isVersionProperty() {
        return (Boolean)this.isVersion.get();
    }

    @NonNull
    public SqlIdentifier getColumnName() {
        return (SqlIdentifier)this.columnName.get();
    }

    public boolean isEmbedded() {
        return (Boolean)this.isEmbedded.get();
    }

    public boolean isInsertOnly() {
        return (Boolean)this.isInsertable.get() != false && (Boolean)this.isUpdatable.get() == false;
    }

    public boolean isTransient() {
        return (Boolean)this.isTransient.get();
    }

    private SqlIdentifier createSqlIdentifier(String name) {
        return this.isForceQuote() ? SqlIdentifier.quoted((String)name) : SqlIdentifier.unquoted((String)name);
    }
}

