/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.jdbc.mapping;

import cn.dinodev.spring.data.jdbc.mapping.DerivedSqlIdentifier;
import jakarta.persistence.Table;
import java.util.Optional;
import org.springframework.data.mapping.model.BasicPersistentEntity;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.relational.core.sql.SqlIdentifier;
import org.springframework.data.util.Lazy;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.StringUtils;

public class DinoJdbcPersistentEntity<T>
extends BasicPersistentEntity<T, RelationalPersistentProperty>
implements RelationalPersistentEntity<T> {
    private final NamingStrategy namingStrategy;
    private final Lazy<Optional<SqlIdentifier>> tableNameLazy;
    private boolean forceQuote = true;

    public DinoJdbcPersistentEntity(TypeInformation<T> information, NamingStrategy namingStrategy) {
        super(information);
        this.namingStrategy = namingStrategy;
        this.tableNameLazy = Lazy.of(() -> Optional.ofNullable((Table)this.findAnnotation(Table.class)).map(Table::name).filter(StringUtils::hasText).map(this::createSqlIdentifier));
    }

    private SqlIdentifier createSqlIdentifier(String name) {
        return this.isForceQuote() ? SqlIdentifier.quoted((String)name) : SqlIdentifier.unquoted((String)name);
    }

    private SqlIdentifier createDerivedSqlIdentifier(String name) {
        return new DerivedSqlIdentifier(name, this.isForceQuote());
    }

    public boolean isForceQuote() {
        return this.forceQuote;
    }

    public void setForceQuote(boolean forceQuote) {
        this.forceQuote = forceQuote;
    }

    @NonNull
    public SqlIdentifier getTableName() {
        return ((Optional)this.tableNameLazy.get()).orElseGet(() -> {
            String schema = this.namingStrategy.getSchema();
            SqlIdentifier tableName = this.createDerivedSqlIdentifier(this.namingStrategy.getTableName(this.getType()));
            return StringUtils.hasText((String)schema) ? SqlIdentifier.from((SqlIdentifier[])new SqlIdentifier[]{this.createDerivedSqlIdentifier(schema), tableName}) : tableName;
        });
    }

    @NonNull
    public SqlIdentifier getIdColumn() {
        return ((RelationalPersistentProperty)this.getRequiredIdProperty()).getColumnName();
    }

    public String toString() {
        return String.format("RelationalPersistentEntityImpl<%s>", this.getType());
    }
}

