/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.jdbc;

import cn.dinodev.spring.data.jdbc.mapping.DinoJdbcPersistentEntity;
import cn.dinodev.spring.data.jdbc.mapping.DinoJdbcPersistentProperty;
import jakarta.persistence.Table;
import org.springframework.data.jdbc.core.mapping.JdbcMappingContext;
import org.springframework.data.mapping.Parameter;
import org.springframework.data.mapping.PersistentEntity;
import org.springframework.data.mapping.PreferredConstructor;
import org.springframework.data.mapping.model.Property;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.TypeInformation;
import org.springframework.lang.NonNull;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DinoJdbcMappingContext
extends JdbcMappingContext {
    private static final String MISSING_PARAMETER_NAME = "A constructor parameter name must not be null to be used with Spring Data JDBC! Offending parameter: %s";

    public DinoJdbcMappingContext(NamingStrategy namingStrategy) {
        super(namingStrategy);
    }

    @NonNull
    protected <T> RelationalPersistentEntity<T> createPersistentEntity(@NonNull TypeInformation<T> typeInformation) {
        DinoJdbcPersistentEntity<T> entity = new DinoJdbcPersistentEntity<T>(typeInformation, this.getNamingStrategy());
        entity.setForceQuote(this.isForceQuote());
        PreferredConstructor constructor = entity.getPersistenceConstructor();
        if (constructor == null) {
            return entity;
        }
        for (Parameter parameter : constructor.getParameters()) {
            Assert.state((boolean)StringUtils.hasText((String)parameter.getName()), () -> String.format(MISSING_PARAMETER_NAME, parameter));
        }
        return entity;
    }

    @NonNull
    protected RelationalPersistentProperty createPersistentProperty(@NonNull Property property, @NonNull RelationalPersistentEntity<?> owner, @NonNull SimpleTypeHolder simpleTypeHolder) {
        DinoJdbcPersistentProperty persistentProperty = new DinoJdbcPersistentProperty(property, (PersistentEntity<?, RelationalPersistentProperty>)owner, simpleTypeHolder, this.getNamingStrategy());
        persistentProperty.setForceQuote(this.isForceQuote());
        return persistentProperty;
    }

    protected boolean shouldCreatePersistentEntityFor(@NonNull TypeInformation<?> type) {
        return super.shouldCreatePersistentEntityFor(type) && (type.getType().isAnnotationPresent(Table.class) || type.getType().isAnnotationPresent(org.springframework.data.relational.core.mapping.Table.class));
    }
}

