/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.domain;

import java.io.Serializable;
import lombok.Generated;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;

public class LimitOffsetPageable
implements Pageable,
Serializable {
    private final int limit;
    private final long offset;
    private final Sort sort;

    public LimitOffsetPageable(long offset, int limit, Sort sort) {
        if (offset < 0L) {
            throw new IllegalArgumentException("Offset index must not be less than zero!");
        }
        if (limit < 1) {
            throw new IllegalArgumentException("Limit must not be less than one!");
        }
        this.limit = limit;
        this.offset = offset;
        this.sort = sort;
    }

    public LimitOffsetPageable(long offset, int limit, Sort.Direction direction, String ... properties) {
        this(offset, limit, Sort.by((Sort.Direction)direction, (String[])properties));
    }

    public LimitOffsetPageable(long offset, int limit) {
        this(offset, limit, Sort.unsorted());
    }

    public int getPageNumber() {
        return (int)(this.offset / (long)this.limit);
    }

    public int getPageSize() {
        return this.limit;
    }

    public long getOffset() {
        return this.offset;
    }

    @NonNull
    public Sort getSort() {
        return this.sort;
    }

    @NonNull
    public Pageable next() {
        return new LimitOffsetPageable(this.getOffset() + (long)this.getPageSize(), this.getPageSize(), this.getSort());
    }

    public LimitOffsetPageable previous() {
        return this.hasPrevious() ? new LimitOffsetPageable(this.getOffset() - (long)this.getPageSize(), this.getPageSize(), this.getSort()) : this;
    }

    @NonNull
    public Pageable previousOrFirst() {
        return this.hasPrevious() ? this.previous() : this.first();
    }

    @NonNull
    public Pageable first() {
        return new LimitOffsetPageable(0L, this.getPageSize(), this.getSort());
    }

    public boolean hasPrevious() {
        return this.offset > (long)this.limit;
    }

    @NonNull
    public Pageable withPage(int pageNumber) {
        return new LimitOffsetPageable(1L * (long)pageNumber * (long)this.getPageSize(), this.getPageSize(), this.getSort());
    }

    @Generated
    public int getLimit() {
        return this.limit;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LimitOffsetPageable)) {
            return false;
        }
        LimitOffsetPageable other = (LimitOffsetPageable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLimit() != other.getLimit()) {
            return false;
        }
        if (this.getOffset() != other.getOffset()) {
            return false;
        }
        Sort this$sort = this.getSort();
        Sort other$sort = other.getSort();
        return !(this$sort == null ? other$sort != null : !this$sort.equals(other$sort));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof LimitOffsetPageable;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLimit();
        long $offset = this.getOffset();
        result = result * 59 + (int)($offset >>> 32 ^ $offset);
        Sort $sort = this.getSort();
        result = result * 59 + ($sort == null ? 43 : $sort.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "LimitOffsetPageable(limit=" + this.getLimit() + ", offset=" + this.getOffset() + ", sort=" + this.getSort() + ")";
    }
}

