/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.dao.impl;

import cn.dinodev.spring.commons.context.ContextHelper;
import cn.dinodev.spring.commons.utils.TypeUtils;
import cn.dinodev.spring.data.dao.EntityMeta;
import cn.dinodev.spring.data.dao.JdbcSelectExecutor;
import cn.dinodev.spring.data.domain.Versioned;
import cn.dinodev.spring.data.sql.builder.DeleteSqlBuilder;
import cn.dinodev.spring.data.sql.builder.SelectSqlBuilder;
import cn.dinodev.spring.data.sql.builder.UpdateSqlBuilder;
import cn.dinodev.spring.data.sql.dialect.Dialect;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.jdbc.core.JdbcAggregateOperations;
import org.springframework.data.jdbc.core.convert.JdbcConverter;
import org.springframework.data.jdbc.repository.support.SimpleJdbcRepository;
import org.springframework.data.relational.core.mapping.RelationalPersistentEntity;
import org.springframework.data.relational.core.mapping.RelationalPersistentProperty;
import org.springframework.data.util.CastUtils;
import org.springframework.jdbc.core.ArgumentPreparedStatementSetter;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.support.GeneratedKeyHolder;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.KeyHolder;
import org.springframework.util.Assert;

public class DinoJdbcRepositoryBase<T, K>
extends SimpleJdbcRepository<T, K>
implements JdbcSelectExecutor<T, K> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DinoJdbcRepositoryBase.class);
    private final RelationalPersistentEntity<T> entity;
    private final EntityMeta entityInfo;
    @Nonnull
    private JdbcTemplate jdbcTemplate;
    @Nonnull
    private Dialect dialect;
    @Nonnull
    private ConversionService conversionService;

    public DinoJdbcRepositoryBase(JdbcAggregateOperations entityOperations, RelationalPersistentEntity<T> entity, JdbcConverter converter) {
        super(entityOperations, entity, converter);
        this.entity = entity;
        this.jdbcTemplate = (JdbcTemplate)ContextHelper.findBean(JdbcTemplate.class);
        this.dialect = (Dialect)ContextHelper.findBean(Dialect.class);
        this.conversionService = (ConversionService)ContextHelper.findBean((String)"dataConversionService", ConversionService.class);
        this.entityInfo = EntityMeta.of(this.dialect, this.entityClass());
    }

    @Override
    public Class<T> entityClass() {
        return this.entity.getType();
    }

    @Override
    public EntityMeta entityMeta() {
        return this.entityInfo;
    }

    @Override
    @Nullable
    public Class<K> keyClass() {
        RelationalPersistentProperty tp = (RelationalPersistentProperty)this.entity.getIdProperty();
        if (Objects.nonNull(tp)) {
            return tp.getType();
        }
        return null;
    }

    @Override
    public Dialect dialect() {
        return this.dialect;
    }

    @Override
    public <C> String tableName(Class<C> cls) {
        EntityMeta meta = EntityMeta.of(this.dialect, cls);
        return meta.getQuotedTableName();
    }

    @Override
    public <P> List<P> queryList(@Nonnull String sql, @Nonnull Class<P> clazz, Object ... params) {
        if (log.isDebugEnabled()) {
            log.debug("query for: {},\nSQL:{},\nPARAMs:", new Object[]{clazz, sql, params});
        }
        if (TypeUtils.isPrimitiveOrString(clazz)) {
            return this.jdbcTemplate.queryForList(sql, clazz, params);
        }
        return this.jdbcTemplate.query(sql, (RowMapper)BeanPropertyRowMapper.newInstance(clazz, (ConversionService)this.conversionService), params);
    }

    @Override
    public <MK, MV> Map<MK, MV> queryForMap(SelectSqlBuilder sql, String keyColumn, Class<MK> keyClass, String valueColumn, Class<MV> valueClass) {
        if (log.isDebugEnabled()) {
            log.debug("query for map: {}:{}, {}:{},\nSQL:{},\nPARAMs:", new Object[]{keyColumn, keyClass, valueColumn, valueClass, sql.getSql(), sql.getParams()});
        }
        Assert.isTrue((boolean)TypeUtils.isPrimitiveOrString(keyClass), (String)"key must be primitive class");
        boolean isPrimitiveForValueColumn = TypeUtils.isPrimitiveOrString(valueClass);
        HashMap result = new HashMap(20);
        this.jdbcTemplate.query(sql.getSql(), rs -> {
            Object key = CastUtils.cast((Object)Objects.requireNonNull(JdbcUtils.getResultSetValue((ResultSet)rs, (int)rs.findColumn(keyColumn), (Class)keyClass)));
            if (isPrimitiveForValueColumn) {
                Object value = CastUtils.cast((Object)Objects.requireNonNull(JdbcUtils.getResultSetValue((ResultSet)rs, (int)rs.findColumn(valueColumn), (Class)valueClass)));
                result.put(key, value);
            } else {
                Object resultSetValue = JdbcUtils.getResultSetValue((ResultSet)rs, (int)rs.findColumn(valueColumn));
                Object convert = this.conversionService.convert(resultSetValue, valueClass);
                result.put(key, convert);
            }
        }, sql.getParams());
        return result;
    }

    @Override
    public <MK, MV> Map<MK, MV> queryForMap(String sql, String keyColumn, Class<MK> keyClass, Class<MV> valueClass, Object ... params) {
        if (log.isDebugEnabled()) {
            log.debug("query for map: {}:{}, valueClass:{},\nSQL:{},\nPARAMs:", new Object[]{keyColumn, keyClass, valueClass, sql, params});
        }
        Assert.isTrue((boolean)TypeUtils.isPrimitiveOrString(keyClass), (String)"key must be primitive class");
        if (TypeUtils.isPrimitiveOrString(valueClass)) {
            return (Map)this.jdbcTemplate.query(sql, rs -> {
                Assert.isTrue((rs.getMetaData().getColumnCount() == 2 ? 1 : 0) != 0, (String)"resulset column count must be 2,as valueClass is primitive class");
                int keyIndex = rs.findColumn(keyColumn);
                HashMap<Object, Object> result = new HashMap<Object, Object>(20);
                while (rs.next()) {
                    Object key = TypeUtils.cast((Object)JdbcUtils.getResultSetValue((ResultSet)rs, (int)keyIndex, (Class)keyClass));
                    Object value = TypeUtils.cast((Object)JdbcUtils.getResultSetValue((ResultSet)rs, (int)(3 - keyIndex), (Class)valueClass));
                    result.put(key, value);
                }
                return result;
            }, params);
        }
        BeanPropertyRowMapper mapper = BeanPropertyRowMapper.newInstance(valueClass, (ConversionService)this.conversionService);
        return (Map)this.jdbcTemplate.query(sql, rs -> {
            HashMap<Object, Object> result = new HashMap<Object, Object>(20);
            int keyIndex = rs.findColumn(keyColumn);
            int rowNum = 0;
            while (rs.next()) {
                Object key = TypeUtils.cast((Object)JdbcUtils.getResultSetValue((ResultSet)rs, (int)keyIndex, (Class)keyClass));
                Object value = mapper.mapRow(rs, rowNum++);
                result.put(key, value);
            }
            return result;
        }, params);
    }

    @Override
    public K save(String sql, Object ... params) {
        GeneratedKeyHolder keys = new GeneratedKeyHolder();
        ArgumentPreparedStatementSetter argSetter = new ArgumentPreparedStatementSetter(params);
        this.jdbcTemplate.update(con -> {
            PreparedStatement ps = con.prepareStatement(sql, 1);
            argSetter.setValues(ps);
            return ps;
        }, (KeyHolder)keys);
        RelationalPersistentProperty idAttr = (RelationalPersistentProperty)this.entity.getIdProperty();
        Map map = keys.getKeys();
        if (idAttr == null || map == null || !map.containsKey(idAttr.getColumnName().getReference())) {
            return null;
        }
        String v = map.get(idAttr.getName()).toString();
        Class<K> k = this.keyClass();
        log.info("entity key:{} of value {}", k, (Object)v);
        if (v == null || k == null) {
            return null;
        }
        if (k.isAssignableFrom(Long.class)) {
            return k.cast(Long.valueOf(v));
        }
        if (k.isAssignableFrom(String.class)) {
            return k.cast(v);
        }
        if (k.isAssignableFrom(Integer.class)) {
            return k.cast(Integer.valueOf(v));
        }
        return null;
    }

    @Override
    public boolean updateById(K id, Map<String, Object> columnValue) {
        UpdateSqlBuilder sql = new UpdateSqlBuilder(this.tableName());
        sql.eq("id", id);
        for (Map.Entry<String, Object> kv : columnValue.entrySet()) {
            RelationalPersistentProperty colProp = (RelationalPersistentProperty)this.entity.getPersistentProperty(kv.getKey());
            String colName = Objects.isNull(colProp) ? kv.getKey() : colProp.getColumnName().getReference();
            sql.set(colName, kv.getValue());
        }
        return this.jdbcTemplate.update(sql.getSql(), sql.getParams()) == 1;
    }

    @Override
    public boolean updateByIdWithVersion(K id, Map<String, Object> columnValue, Number version) {
        Assert.isTrue((boolean)this.entityInfo.isVersioned(), (String)(this.entityInfo.getDomainClass() + " must implements " + Versioned.class));
        UpdateSqlBuilder sql = new UpdateSqlBuilder(this.tableName());
        sql.eq("id", id);
        sql.eq("version", version);
        for (Map.Entry<String, Object> kv : columnValue.entrySet()) {
            RelationalPersistentProperty colProp = (RelationalPersistentProperty)this.entity.getPersistentProperty(kv.getKey());
            String colName = Objects.isNull(colProp) ? kv.getKey() : colProp.getColumnName().getReference();
            sql.set(colName, kv.getValue());
        }
        sql.set("version = version+1");
        return this.jdbcTemplate.update(sql.getSql(), sql.getParams()) == 1;
    }

    @Override
    public long update(UpdateSqlBuilder updateSqlBuilder) {
        return this.jdbcTemplate.update(updateSqlBuilder.getSql(), updateSqlBuilder.getParams());
    }

    @Override
    public long delete(DeleteSqlBuilder deleteSqlBuilder) {
        return this.jdbcTemplate.update(deleteSqlBuilder.getSql(), deleteSqlBuilder.getParams());
    }
}

