/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.dao;

import cn.dinodev.spring.commons.context.ContextHelper;
import cn.dinodev.spring.data.dao.JdbcHelperExcutor;
import cn.dinodev.spring.data.sql.builder.DeleteSqlBuilder;
import cn.dinodev.spring.data.sql.builder.InsertSqlBuilder;
import cn.dinodev.spring.data.sql.builder.SelectSqlBuilder;
import cn.dinodev.spring.data.sql.builder.UpdateSqlBuilder;
import cn.dinodev.spring.data.sql.dialect.Dialect;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.util.Assert;

@NoRepositoryBean
public interface JdbcSelectExecutor<T, K>
extends JdbcHelperExcutor<T, K> {
    public Dialect dialect();

    default public SelectSqlBuilder newSelect() {
        SelectSqlBuilder select = new SelectSqlBuilder(this.dialect(), this.tableName());
        if (this.entityMeta().isTenantRow() && Objects.nonNull(ContextHelper.currentTenantId())) {
            select.eq("tenant_id", ContextHelper.currentTenantId());
        }
        return select;
    }

    default public SelectSqlBuilder newSelectWithoutTenant() {
        return new SelectSqlBuilder(this.dialect(), this.tableName());
    }

    default public SelectSqlBuilder newSelect(String tableAlias) {
        Assert.hasText((String)tableAlias, (String)"tableAlias is empty");
        SelectSqlBuilder select = new SelectSqlBuilder(this.dialect(), this.tableName(), tableAlias);
        if (this.entityMeta().isTenantRow() && Objects.nonNull(ContextHelper.currentTenantId())) {
            select.eq(String.format("%s.%s", tableAlias, "tenant_id"), ContextHelper.currentTenantId());
        }
        return select;
    }

    default public SelectSqlBuilder newSelectWithoutTenant(String tableAlias) {
        Assert.hasText((String)tableAlias, (String)"tableAlias is empty");
        return new SelectSqlBuilder(this.dialect(), this.tableName(), tableAlias);
    }

    default public <E> SelectSqlBuilder newSelect(Class<E> entity, String tableAlias) {
        return StringUtils.isEmpty((CharSequence)tableAlias) ? new SelectSqlBuilder(this.dialect(), this.tableName(entity)) : new SelectSqlBuilder(this.dialect(), this.tableName(entity), tableAlias);
    }

    default public DeleteSqlBuilder newDelete() {
        DeleteSqlBuilder delete = new DeleteSqlBuilder(this.tableName());
        if (this.entityMeta().isTenantRow() && Objects.nonNull(ContextHelper.currentTenantId())) {
            delete.eq("tenant_id", ContextHelper.currentTenantId());
        }
        return delete;
    }

    default public DeleteSqlBuilder newDelete(String tableAlias) {
        Assert.hasText((String)tableAlias, (String)"tableAlias is empty");
        DeleteSqlBuilder delete = new DeleteSqlBuilder(this.tableName(), tableAlias);
        if (this.entityMeta().isTenantRow() && Objects.nonNull(ContextHelper.currentTenantId())) {
            delete.eq(String.format("%s.%s", tableAlias, "tenant_id"), ContextHelper.currentTenantId());
        }
        return delete;
    }

    default public UpdateSqlBuilder newUpdate() {
        UpdateSqlBuilder update = new UpdateSqlBuilder(this.tableName());
        if (this.entityMeta().isTenantRow() && Objects.nonNull(ContextHelper.currentTenantId())) {
            update.eq("tenant_id", ContextHelper.currentTenantId());
        }
        return update;
    }

    default public UpdateSqlBuilder newUpdate(String alias) {
        UpdateSqlBuilder update = new UpdateSqlBuilder(this.tableName(), alias);
        if (this.entityMeta().isTenantRow() && Objects.nonNull(ContextHelper.currentTenantId())) {
            update.eq(String.format("%s.%s", alias, "tenant_id"), ContextHelper.currentTenantId());
        }
        return update;
    }

    default public InsertSqlBuilder newInsert() {
        InsertSqlBuilder insert = new InsertSqlBuilder(this.tableName());
        if (this.entityMeta().isTenantRow() && Objects.nonNull(ContextHelper.currentTenantId())) {
            insert.set("tenant_id", ContextHelper.currentTenantId());
        }
        return insert;
    }

    default public List<T> findAllById(Collection<K> ids) {
        SelectSqlBuilder sql = this.newSelect();
        sql.in("id", ids);
        return this.queryList(sql);
    }

    default public <C> List<C> findAllById(Collection<K> ids, Class<C> cls) {
        SelectSqlBuilder sql = this.newSelect();
        sql.in("id", ids);
        return this.queryList(sql, cls);
    }

    default public <C> List<C> findAll(Class<C> cls) {
        SelectSqlBuilder sql = this.newSelect();
        return this.queryList(sql, cls);
    }

    default public List<T> queryList(SelectSqlBuilder sql) {
        return this.queryList(sql, this.entityClass());
    }

    default public List<T> queryList(SelectSqlBuilder sql, Sort sort) {
        return this.queryList(sql, this.entityClass(), sort);
    }

    default public <P> List<P> queryList(SelectSqlBuilder sql, Class<P> clazz) {
        return this.queryList(sql.getSql(), clazz, sql.getParams());
    }

    default public <P> List<P> queryList(SelectSqlBuilder sql, Class<P> clazz, Sort sort) {
        if (!Objects.isNull(sort) && sort.isSorted()) {
            sort.forEach(o -> sql.orderBy(o.getProperty(), o.isAscending()));
        }
        return this.queryList(sql.getSql(), clazz, sql.getParams());
    }

    public <P> List<P> queryList(@Nonnull String var1, @Nonnull Class<P> var2, Object ... var3);

    default public T getOne(SelectSqlBuilder sql) {
        List<T> rs = this.queryList(sql);
        if (CollectionUtils.isNotEmpty(rs)) {
            return rs.get(0);
        }
        return null;
    }

    default public <P> P getOne(SelectSqlBuilder sql, Class<P> clazz) {
        List<P> rs = this.queryList(sql, clazz);
        if (CollectionUtils.isNotEmpty(rs)) {
            return rs.get(0);
        }
        return null;
    }

    default public <P> P getOne(String sql, Class<P> clazz, Object ... params) {
        List<P> rs = this.queryList(sql, clazz, params);
        if (CollectionUtils.isNotEmpty(rs)) {
            return rs.get(0);
        }
        return null;
    }

    default public long count(SelectSqlBuilder sql) {
        Long l = this.getOne(sql, Long.class);
        return l == null ? 0L : l;
    }

    default public long count(String sql, Object ... params) {
        Long l = this.getOne(sql, Long.class, params);
        return l == null ? 0L : l;
    }

    default public <MK, MV> Map<MK, MV> queryForMap(SelectSqlBuilder sql, String keyColumn, Class<MK> keyClass, Class<MV> valueClass) {
        return this.queryForMap(sql.getSql(), keyColumn, keyClass, valueClass, sql.getParams());
    }

    public <MK, MV> Map<MK, MV> queryForMap(SelectSqlBuilder var1, String var2, Class<MK> var3, String var4, Class<MV> var5);

    public <MK, MV> Map<MK, MV> queryForMap(String var1, String var2, Class<MK> var3, Class<MV> var4, Object ... var5);

    default public Page<T> queryPage(SelectSqlBuilder sql, Pageable pageable) {
        return this.queryPage(sql, pageable, this.entityClass());
    }

    default public <P> Page<P> queryPage(SelectSqlBuilder sql, Pageable pageable, Class<P> clazz) {
        Sort sort = pageable.getSort();
        if (sort.isSorted()) {
            sort.forEach(o -> sql.orderBy(o.getProperty(), o.isAscending()));
        }
        if (pageable.isUnpaged()) {
            return new PageImpl(this.queryList(sql, clazz));
        }
        sql.limit(pageable.getPageSize(), pageable.getOffset());
        return new PageImpl(this.queryList(sql, clazz), pageable, this.count(sql.getCountSql(), sql.getParams()));
    }

    default public Page<T> queryPage(SelectSqlBuilder sql, SelectSqlBuilder countSql, Pageable pageable) {
        return this.queryPage(sql, countSql, pageable, this.entityClass());
    }

    default public <P> Page<P> queryPage(SelectSqlBuilder sql, SelectSqlBuilder countSql, Pageable pageable, Class<P> clazz) {
        Sort sort = pageable.getSort();
        if (sort.isSorted()) {
            sort.forEach(o -> sql.orderBy(o.getProperty(), o.isAscending()));
        }
        if (pageable.isUnpaged()) {
            return new PageImpl(this.queryList(sql, clazz));
        }
        sql.limit(pageable.getPageSize(), pageable.getOffset());
        return new PageImpl(this.queryList(sql, clazz), pageable, this.count(countSql));
    }

    public K save(@Nonnull String var1, Object ... var2);
}

