/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.dao;

import cn.dinodev.spring.commons.context.ContextHelper;
import cn.dinodev.spring.commons.utils.NamingUtils;
import cn.dinodev.spring.data.domain.EntityBase;
import cn.dinodev.spring.data.domain.LogicalDelete;
import cn.dinodev.spring.data.domain.TenantLevel;
import cn.dinodev.spring.data.domain.TenantRowEntity;
import cn.dinodev.spring.data.domain.TenantTableEntity;
import cn.dinodev.spring.data.domain.Versioned;
import cn.dinodev.spring.data.sql.dialect.Dialect;
import jakarta.persistence.Table;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.data.util.Lazy;
import org.springframework.util.Assert;

public class EntityMeta {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EntityMeta.class);
    private static final Map<Class<?>, EntityMeta> ENTITY_META_CACHE = new HashMap();
    private static final Lazy<Dialect> DEFAULT_DIALECT = Lazy.of(() -> (Dialect)ContextHelper.findBean(Dialect.class));
    private final Dialect dialect;
    private final Class<?> domainClass;
    private final TenantLevel tenantLevel;
    private final String tableName;
    private final boolean logicalDelete;
    private final boolean versioned;
    private final Lazy<String> quotedTableName;

    private EntityMeta(Dialect dialect, Class<?> domainClass, TenantLevel tenantLevel, String tableName, boolean logicalDelete, boolean versioned) {
        this.dialect = dialect;
        this.domainClass = domainClass;
        this.tenantLevel = tenantLevel;
        this.tableName = tableName;
        this.logicalDelete = logicalDelete;
        this.versioned = versioned;
        this.quotedTableName = Lazy.of(() -> dialect.quoteTableName(tableName));
        ENTITY_META_CACHE.put(domainClass, this);
    }

    public boolean isTenantTable() {
        return this.tenantLevel == TenantLevel.TABLE;
    }

    public boolean isTenantRow() {
        return this.tenantLevel == TenantLevel.ROW;
    }

    public boolean isTenantSchema() {
        return this.tenantLevel == TenantLevel.SCHEMA;
    }

    public boolean isTenantable() {
        return this.isTenantTable() || this.isTenantRow() || this.isTenantSchema();
    }

    public String getQuotedTableName() {
        if (this.isTenantTable()) {
            return this.dialect.quoteTableName(this.tableName + "_" + ContextHelper.currentTenantId());
        }
        return (String)this.quotedTableName.get();
    }

    public static EntityMeta of(Dialect dialect, Class<?> cls) {
        Table tableAnno;
        EntityMeta cachedMeta = ENTITY_META_CACHE.get(cls);
        if (Objects.nonNull(cachedMeta)) {
            return cachedMeta;
        }
        TenantLevel tenantLevel = TenantLevel.NOT;
        if (TenantRowEntity.class.isAssignableFrom(cls)) {
            tenantLevel = TenantLevel.ROW;
        }
        if (TenantTableEntity.class.isAssignableFrom(cls)) {
            tenantLevel = TenantLevel.TABLE;
        }
        String tableName = (tableAnno = (Table)AnnotationUtils.findAnnotation(cls, Table.class)) != null ? tableAnno.name() : NamingUtils.toSnake((String)cls.getSimpleName());
        boolean logicalDelete = LogicalDelete.class.isAssignableFrom(cls);
        if (logicalDelete && !EntityBase.class.isAssignableFrom(cls)) {
            log.error("entity:{} is LogicalDelete but not extends EntityBase", (Object)cls.getName());
            Assert.isAssignable(EntityBase.class, cls, (String)"");
        }
        boolean versioned = Versioned.class.isAssignableFrom(cls);
        return new EntityMeta(dialect, cls, tenantLevel, tableName, logicalDelete, versioned);
    }

    public static EntityMeta of(Class<?> cls) {
        return EntityMeta.of((Dialect)DEFAULT_DIALECT.get(), cls);
    }

    @Generated
    public Dialect getDialect() {
        return this.dialect;
    }

    @Generated
    public Class<?> getDomainClass() {
        return this.domainClass;
    }

    @Generated
    public TenantLevel getTenantLevel() {
        return this.tenantLevel;
    }

    @Generated
    public String getTableName() {
        return this.tableName;
    }

    @Generated
    public boolean isLogicalDelete() {
        return this.logicalDelete;
    }

    @Generated
    public boolean isVersioned() {
        return this.versioned;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EntityMeta)) {
            return false;
        }
        EntityMeta other = (EntityMeta)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isLogicalDelete() != other.isLogicalDelete()) {
            return false;
        }
        if (this.isVersioned() != other.isVersioned()) {
            return false;
        }
        Dialect this$dialect = this.getDialect();
        Dialect other$dialect = other.getDialect();
        if (this$dialect == null ? other$dialect != null : !this$dialect.equals(other$dialect)) {
            return false;
        }
        Class<?> this$domainClass = this.getDomainClass();
        Class<?> other$domainClass = other.getDomainClass();
        if (this$domainClass == null ? other$domainClass != null : !this$domainClass.equals(other$domainClass)) {
            return false;
        }
        TenantLevel this$tenantLevel = this.getTenantLevel();
        TenantLevel other$tenantLevel = other.getTenantLevel();
        if (this$tenantLevel == null ? other$tenantLevel != null : !((Object)((Object)this$tenantLevel)).equals((Object)other$tenantLevel)) {
            return false;
        }
        String this$tableName = this.getTableName();
        String other$tableName = other.getTableName();
        if (this$tableName == null ? other$tableName != null : !this$tableName.equals(other$tableName)) {
            return false;
        }
        String this$quotedTableName = this.getQuotedTableName();
        String other$quotedTableName = other.getQuotedTableName();
        return !(this$quotedTableName == null ? other$quotedTableName != null : !this$quotedTableName.equals(other$quotedTableName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof EntityMeta;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isLogicalDelete() ? 79 : 97);
        result = result * 59 + (this.isVersioned() ? 79 : 97);
        Dialect $dialect = this.getDialect();
        result = result * 59 + ($dialect == null ? 43 : $dialect.hashCode());
        Class<?> $domainClass = this.getDomainClass();
        result = result * 59 + ($domainClass == null ? 43 : $domainClass.hashCode());
        TenantLevel $tenantLevel = this.getTenantLevel();
        result = result * 59 + ($tenantLevel == null ? 43 : ((Object)((Object)$tenantLevel)).hashCode());
        String $tableName = this.getTableName();
        result = result * 59 + ($tableName == null ? 43 : $tableName.hashCode());
        String $quotedTableName = this.getQuotedTableName();
        result = result * 59 + ($quotedTableName == null ? 43 : $quotedTableName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "EntityMeta(dialect=" + this.getDialect() + ", domainClass=" + this.getDomainClass() + ", tenantLevel=" + this.getTenantLevel() + ", tableName=" + this.getTableName() + ", logicalDelete=" + this.isLogicalDelete() + ", versioned=" + this.isVersioned() + ", quotedTableName=" + this.getQuotedTableName() + ")";
    }
}

