/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.dao;

import cn.dinodev.spring.data.dao.JdbcSelectExecutor;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.data.jdbc.repository.query.Modifying;
import org.springframework.data.jdbc.repository.query.Query;
import org.springframework.data.repository.ListCrudRepository;
import org.springframework.data.repository.NoRepositoryBean;
import org.springframework.data.repository.PagingAndSortingRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.transaction.annotation.Transactional;

@NoRepositoryBean
public interface CrudRepositoryBase<T, K extends Serializable>
extends ListCrudRepository<T, K>,
JdbcSelectExecutor<T, K>,
PagingAndSortingRepository<T, K> {
    default public T getById(K id) {
        return this.findById(id).orElse(null);
    }

    default public T postQuery(T entity) {
        return entity;
    }

    default public List<T> postQuery(List<T> entities) {
        if (CollectionUtils.isNotEmpty(entities)) {
            entities.forEach(this::postQuery);
        }
        return entities;
    }

    @Modifying
    @Transactional(rollbackFor={Exception.class})
    @Query(value="UPDATE #{#entityName} e SET e.status=:status WHERE e.id in :ids")
    public int updateStatusByIds(@Param(value="ids") Collection<K> var1, @Param(value="status") String var2);

    @Modifying
    @Transactional(rollbackFor={Exception.class})
    @Query(value="UPDATE #{#entityName} e SET e.status=:status WHERE e.id = :id")
    public int updateStatusById(@Param(value="id") K var1, @Param(value="status") String var2);

    @Query(value="SELECT count(1) AS cnt FROM #{#entityName} e WHERE e.status='ok'")
    public int countOk();
}

