/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.converts;

import cn.dinodev.spring.data.converts.Jsonb;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.ConditionalGenericConverter;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={PGobject.class})
@WritingConverter
public class PostgreJsonbWritingConverter
implements ConditionalGenericConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgreJsonbWritingConverter.class);
    @Autowired
    private ObjectMapper objectMapper;
    private SimpleTypeHolder simpleTypeHolder = SimpleTypeHolder.DEFAULT;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Set.of(new GenericConverter.ConvertiblePair(Collection.class, PGobject.class), new GenericConverter.ConvertiblePair(Set.class, PGobject.class), new GenericConverter.ConvertiblePair(Map.class, PGobject.class), new GenericConverter.ConvertiblePair(Jsonb.class, PGobject.class), new GenericConverter.ConvertiblePair(Object[].class, PGobject.class), new GenericConverter.ConvertiblePair(String[].class, PGobject.class), new GenericConverter.ConvertiblePair(Boolean[].class, PGobject.class), new GenericConverter.ConvertiblePair(Number[].class, PGobject.class));
    }

    public boolean matches(@NonNull TypeDescriptor sourceType, @NonNull TypeDescriptor targetType) {
        return !this.simpleTypeHolder.isSimpleType(sourceType.getType());
    }

    public Object convert(@Nullable Object source, @NonNull TypeDescriptor sourceType, @NonNull TypeDescriptor targetType) {
        PGobject pg = new PGobject();
        pg.setType("jsonb");
        try {
            if (Objects.isNull(source)) {
                pg.setValue(null);
            }
            pg.setValue(this.objectMapper.writeValueAsString(source));
            return pg;
        }
        catch (JsonProcessingException | SQLException e) {
            log.error("convert error from:{} to:{} value:{}", new Object[]{sourceType, targetType, source, e});
            throw new ConversionFailedException(sourceType, targetType, source, e);
        }
    }
}

