/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.converts;

import cn.dinodev.spring.commons.utils.TypeUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.convert.ConversionFailedException;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={PGobject.class})
@ReadingConverter
public class PostgreJsonbReadingConverter
implements GenericConverter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PostgreJsonbReadingConverter.class);
    @Autowired
    private ObjectMapper objectMapper;

    public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
        return Set.of(new GenericConverter.ConvertiblePair(PGobject.class, Collection.class), new GenericConverter.ConvertiblePair(PGobject.class, Object[].class), new GenericConverter.ConvertiblePair(PGobject.class, Map.class), new GenericConverter.ConvertiblePair(PGobject.class, Object.class), new GenericConverter.ConvertiblePair(PGobject.class, String.class), new GenericConverter.ConvertiblePair(PGobject.class, Boolean.class), new GenericConverter.ConvertiblePair(PGobject.class, Number.class));
    }

    public Object convert(@Nullable Object source, @NonNull TypeDescriptor sourceType, @NonNull TypeDescriptor targetType) {
        PGobject sourceData = (PGobject)TypeUtils.cast((Object)source);
        try {
            if (targetType.isCollection()) {
                return this.convertCollection(sourceData, targetType);
            }
            if (targetType.isArray()) {
                return this.convertArray(sourceData, targetType);
            }
            if (targetType.isMap()) {
                return this.convertMap(sourceData, targetType);
            }
            return this.convertObject(sourceData, targetType);
        }
        catch (JsonProcessingException e) {
            log.error("convert error from:{} to:{} value:{}", new Object[]{sourceType, targetType, source, e});
            throw new ConversionFailedException(sourceType, targetType, source, (Throwable)e);
        }
    }

    private Object convertCollection(PGobject source, TypeDescriptor targetType) throws JsonProcessingException {
        if (source == null || source.getValue() == null || StringUtils.isBlank((CharSequence)source.getValue())) {
            return Collections.emptyList();
        }
        return this.objectMapper.readerForListOf(targetType.getResolvableType().getGeneric(new int[]{0}).getRawClass()).readValue(source.getValue());
    }

    private Object convertArray(PGobject source, TypeDescriptor targetType) throws JsonProcessingException {
        if (source == null || source.getValue() == null || StringUtils.isBlank((CharSequence)source.getValue())) {
            return null;
        }
        return this.objectMapper.readerForArrayOf(targetType.getResolvableType().getComponentType().getRawClass()).readValue(source.getValue());
    }

    private Object convertMap(PGobject source, TypeDescriptor targetType) throws JsonProcessingException {
        if (source == null || source.getValue() == null || StringUtils.isBlank((CharSequence)source.getValue())) {
            return Collections.emptyMap();
        }
        TypeDescriptor mapValueTypeDescriptor = targetType.getMapValueTypeDescriptor();
        if (mapValueTypeDescriptor == null) {
            return Collections.emptyMap();
        }
        return this.objectMapper.readerForMapOf(mapValueTypeDescriptor.getResolvableType().getRawClass()).readValue(source.getValue());
    }

    private Object convertObject(PGobject source, TypeDescriptor targetType) throws JsonProcessingException {
        if (source == null || source.getValue() == null) {
            return null;
        }
        Class cls = targetType.getResolvableType().getRawClass();
        if (cls == null) {
            cls = targetType.getType();
        }
        return this.objectMapper.readerFor(cls).readValue(source.getValue());
    }
}

