/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.converts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.postgresql.util.PGobject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ObjectJsonbConverter
implements AttributeConverter<Object, PGobject> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ObjectJsonbConverter.class);
    @Autowired
    private ObjectMapper objectMapper;

    public PGobject convertToDatabaseColumn(Object attribute) {
        PGobject pg = new PGobject();
        pg.setType("jsonb");
        try {
            if (Objects.isNull(attribute)) {
                pg.setValue(null);
            }
            pg.setValue(this.objectMapper.writeValueAsString(attribute));
            return pg;
        }
        catch (IOException | SQLException e) {
            log.error("error parse json:{}", attribute, (Object)e);
            return null;
        }
    }

    public Object convertToEntityAttribute(PGobject dbData) {
        if (StringUtils.isBlank((CharSequence)dbData.getValue())) {
            return null;
        }
        try {
            return this.objectMapper.readerFor(Object.class).readValue(dbData.getValue());
        }
        catch (JsonProcessingException e) {
            log.error("error Convert to Object json:{}", (Object)dbData.getValue(), (Object)e);
            throw new IllegalArgumentException(e);
        }
    }
}

