/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.converts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.sql.SQLException;
import java.util.List;
import org.postgresql.util.PGobject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@Converter(autoApply=true)
public class ListStringJsonbConverter
implements AttributeConverter<List<String>, PGobject> {
    @Autowired
    private ObjectMapper objectMapper;

    public PGobject convertToDatabaseColumn(List<String> attribute) {
        PGobject pg = new PGobject();
        pg.setType("jsonb");
        try {
            pg.setValue(this.objectMapper.writeValueAsString(attribute));
            return pg;
        }
        catch (JsonProcessingException | SQLException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public List<String> convertToEntityAttribute(PGobject dbData) {
        try {
            return (List)this.objectMapper.readerForListOf(String.class).readValue(dbData.getValue());
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

