/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.converts;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.NullNode;
import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Converter(autoApply=true)
public class JsonStringConvert
implements AttributeConverter<JsonNode, String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JsonStringConvert.class);
    @Autowired
    private ObjectMapper objectMapper;

    public String convertToDatabaseColumn(JsonNode attribute) {
        return attribute.asText();
    }

    public JsonNode convertToEntityAttribute(String dbData) {
        if (Objects.isNull(dbData)) {
            return NullNode.getInstance();
        }
        try {
            return this.objectMapper.readTree(dbData);
        }
        catch (JsonProcessingException e) {
            log.error("convert error:{}", (Object)dbData, (Object)e);
            return null;
        }
    }
}

