/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.converts;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.UntypedObjectDeserializer;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.internal.bind.TypeAdapters;
import java.io.IOException;

public class JacksonCustomerModule
extends SimpleModule {
    public JacksonCustomerModule() {
        this.addDeserializer(JsonElement.class, (JsonDeserializer)new JsonDeserializer<JsonElement>(){
            private final JsonDeserializer<?> delegate = new UntypedObjectDeserializer(null, null);

            public JsonElement deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
                Object val = this.delegate.deserialize(p, ctxt);
                if (val == null) {
                    return JsonNull.INSTANCE;
                }
                return (JsonElement)TypeAdapters.JSON_ELEMENT.fromJson(new Gson().toJson(val));
            }
        });
    }
}

