/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.autoconfig;

import cn.dinodev.spring.commons.context.ContextHelper;
import java.sql.DatabaseMetaData;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import lombok.Generated;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.MigrationVersion;
import org.flywaydb.core.api.callback.Callback;
import org.flywaydb.core.api.configuration.FluentConfiguration;
import org.flywaydb.core.api.migration.JavaMigration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.EnableAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.flyway.FlywayAutoConfiguration;
import org.springframework.boot.autoconfigure.flyway.FlywayConfigurationCustomizer;
import org.springframework.boot.autoconfigure.flyway.FlywayDataSource;
import org.springframework.boot.autoconfigure.flyway.FlywayProperties;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.PropertyMapper;
import org.springframework.boot.jdbc.DataSourceBuilder;
import org.springframework.boot.jdbc.DatabaseDriver;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.datasource.SimpleDriverDataSource;
import org.springframework.jdbc.support.JdbcUtils;
import org.springframework.jdbc.support.MetaDataAccessException;
import org.springframework.lang.NonNull;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnClass(value={Flyway.class})
@ConditionalOnProperty(prefix="spring.flyway", name={"enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={FlywayProperties.class})
@EnableAutoConfiguration(exclude={FlywayAutoConfiguration.class})
public class DinoFlaywayConfiguration
implements ApplicationListener<ApplicationReadyEvent> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DinoFlaywayConfiguration.class);

    public void onApplicationEvent(@NonNull ApplicationReadyEvent event) {
        FluentConfiguration configuration = (FluentConfiguration)ContextHelper.findBean(FluentConfiguration.class);
        Collection javaMigrations = ContextHelper.getApplicationContext().getBeansOfType(JavaMigration.class).values();
        log.info("--->> flyway: exec java migration, count:{}", (Object)javaMigrations.size());
        javaMigrations.forEach(migration -> log.info("   -- {}, class:{}", (Object)this.buildJavaMigrationName((JavaMigration)migration), (Object)migration.getClass().getName()));
        configuration.javaMigrations(javaMigrations.toArray(new JavaMigration[javaMigrations.size()]));
        Flyway flyway = configuration.load();
        flyway.migrate();
    }

    @Bean
    public FlywayConfigurationCustomizer flaywayConfigurationCustomizer() {
        return config -> {
            config.baselineOnMigrate(true);
            config.failOnMissingLocations(false);
        };
    }

    @Bean
    public FluentConfiguration flywayConfiguration(FlywayProperties properties, ResourceLoader resourceLoader, ObjectProvider<DataSource> dataSource, @FlywayDataSource ObjectProvider<DataSource> flywayDataSource, ObjectProvider<FlywayConfigurationCustomizer> fluentConfigurationCustomizers, ObjectProvider<Callback> callbacks) {
        log.info("--->> flyway: setup FlywayConfiguration");
        FluentConfiguration configuration = new FluentConfiguration(resourceLoader.getClassLoader());
        this.configureDataSource(configuration, properties, (DataSource)flywayDataSource.getIfAvailable(), (DataSource)dataSource.getIfUnique());
        this.configureProperties(configuration, properties);
        List<Callback> orderedCallbacks = callbacks.orderedStream().collect(Collectors.toList());
        this.configureCallbacks(configuration, orderedCallbacks);
        fluentConfigurationCustomizers.orderedStream().forEach(customizer -> customizer.customize(configuration));
        this.configureFlywayCallbacks(configuration, orderedCallbacks);
        return configuration;
    }

    private void configureDataSource(FluentConfiguration configuration, FlywayProperties properties, DataSource flywayDataSource, DataSource dataSource) {
        DataSource migrationDataSource = this.getMigrationDataSource(properties, flywayDataSource, dataSource);
        configuration.dataSource(migrationDataSource);
    }

    private DataSource getMigrationDataSource(FlywayProperties properties, DataSource flywayDataSource, DataSource dataSource) {
        if (flywayDataSource != null) {
            return flywayDataSource;
        }
        if (properties.getUrl() != null) {
            DataSourceBuilder builder = DataSourceBuilder.create().type(SimpleDriverDataSource.class);
            builder.url(properties.getUrl());
            this.applyCommonBuilderProperties(properties, builder);
            return builder.build();
        }
        if (properties.getUser() != null && dataSource != null) {
            DataSourceBuilder builder = DataSourceBuilder.derivedFrom((DataSource)dataSource).type(SimpleDriverDataSource.class);
            this.applyCommonBuilderProperties(properties, builder);
            return builder.build();
        }
        Assert.state((dataSource != null ? 1 : 0) != 0, (String)"Flyway migration DataSource missing");
        return dataSource;
    }

    private void applyCommonBuilderProperties(FlywayProperties properties, DataSourceBuilder<?> builder) {
        builder.username(properties.getUser());
        builder.password(properties.getPassword());
        if (StringUtils.hasText((String)properties.getDriverClassName())) {
            builder.driverClassName(properties.getDriverClassName());
        }
    }

    private void configureProperties(FluentConfiguration configuration, FlywayProperties properties) {
        PropertyMapper map = PropertyMapper.get().alwaysApplyingWhenNonNull();
        this.failOnMissingLocations(configuration, properties, map);
        this.createSchemas(configuration, properties, map);
        this.validateMigrationNaming(configuration, properties, map);
    }

    private void failOnMissingLocations(FluentConfiguration configuration, FlywayProperties properties, PropertyMapper map) {
        String[] locations = new LocationResolver(configuration.getDataSource()).resolveLocations(properties.getLocations()).toArray(new String[0]);
        configuration.failOnMissingLocations(properties.isFailOnMissingLocations());
        map.from((Object)locations).to(arg_0 -> ((FluentConfiguration)configuration).locations(arg_0));
        map.from((Object)properties.getEncoding()).to(arg_0 -> ((FluentConfiguration)configuration).encoding(arg_0));
        map.from((Object)properties.getConnectRetries()).to(arg_0 -> ((FluentConfiguration)configuration).connectRetries(arg_0));
        map.from((Object)properties.getConnectRetriesInterval()).to(interval -> configuration.connectRetriesInterval((int)interval.getSeconds()));
        map.from((Object)properties.getLockRetryCount()).to(arg_0 -> ((FluentConfiguration)configuration).lockRetryCount(arg_0));
        map.from((Object)properties.getDefaultSchema()).to(arg_0 -> ((FluentConfiguration)configuration).defaultSchema(arg_0));
        map.from((Object)properties.getSchemas()).as(StringUtils::toStringArray).to(arg_0 -> ((FluentConfiguration)configuration).schemas(arg_0));
    }

    private void createSchemas(FluentConfiguration configuration, FlywayProperties properties, PropertyMapper map) {
        configuration.createSchemas(properties.isCreateSchemas());
        map.from((Object)properties.getTable()).to(arg_0 -> ((FluentConfiguration)configuration).table(arg_0));
        map.from((Object)properties.getTablespace()).to(arg_0 -> ((FluentConfiguration)configuration).tablespace(arg_0));
        map.from((Object)properties.getBaselineDescription()).to(arg_0 -> ((FluentConfiguration)configuration).baselineDescription(arg_0));
        map.from((Object)properties.getBaselineVersion()).to(arg_0 -> ((FluentConfiguration)configuration).baselineVersion(arg_0));
        map.from((Object)properties.getInstalledBy()).to(arg_0 -> ((FluentConfiguration)configuration).installedBy(arg_0));
        map.from((Object)properties.getPlaceholders()).to(arg_0 -> ((FluentConfiguration)configuration).placeholders(arg_0));
        map.from((Object)properties.getPlaceholderPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderPrefix(arg_0));
        map.from((Object)properties.getPlaceholderSuffix()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderSuffix(arg_0));
        map.from((Object)properties.isPlaceholderReplacement()).to(arg_0 -> ((FluentConfiguration)configuration).placeholderReplacement(arg_0));
        map.from((Object)properties.getSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationPrefix(arg_0));
        map.from((Object)properties.getSqlMigrationSuffixes()).as(StringUtils::toStringArray).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSuffixes(arg_0));
        map.from((Object)properties.getSqlMigrationSeparator()).to(arg_0 -> ((FluentConfiguration)configuration).sqlMigrationSeparator(arg_0));
        map.from((Object)properties.getRepeatableSqlMigrationPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).repeatableSqlMigrationPrefix(arg_0));
        map.from((Object)properties.getTarget()).to(arg_0 -> ((FluentConfiguration)configuration).target(arg_0));
        map.from((Object)properties.isBaselineOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).baselineOnMigrate(arg_0));
        map.from((Object)properties.isCleanDisabled()).to(arg_0 -> ((FluentConfiguration)configuration).cleanDisabled(arg_0));
        map.from((Object)properties.isCleanOnValidationError()).to(arg_0 -> ((FluentConfiguration)configuration).cleanOnValidationError(arg_0));
        map.from((Object)properties.isGroup()).to(arg_0 -> ((FluentConfiguration)configuration).group(arg_0));
        map.from((Object)properties.isMixed()).to(arg_0 -> ((FluentConfiguration)configuration).mixed(arg_0));
        map.from((Object)properties.isOutOfOrder()).to(arg_0 -> ((FluentConfiguration)configuration).outOfOrder(arg_0));
        map.from((Object)properties.isSkipDefaultCallbacks()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultCallbacks(arg_0));
        map.from((Object)properties.isSkipDefaultResolvers()).to(arg_0 -> ((FluentConfiguration)configuration).skipDefaultResolvers(arg_0));
    }

    private void validateMigrationNaming(FluentConfiguration configuration, FlywayProperties properties, PropertyMapper map) {
        configuration.validateMigrationNaming(properties.isValidateMigrationNaming());
        map.from((Object)properties.isValidateOnMigrate()).to(arg_0 -> ((FluentConfiguration)configuration).validateOnMigrate(arg_0));
        map.from((Object)properties.getInitSqls()).whenNot(CollectionUtils::isEmpty).as(initSqls -> StringUtils.collectionToDelimitedString((Collection)initSqls, (String)"\n")).to(arg_0 -> ((FluentConfiguration)configuration).initSql(arg_0));
        map.from((Object)properties.getScriptPlaceholderPrefix()).to(arg_0 -> ((FluentConfiguration)configuration).scriptPlaceholderPrefix(arg_0));
        map.from((Object)properties.getScriptPlaceholderSuffix()).to(arg_0 -> ((FluentConfiguration)configuration).scriptPlaceholderSuffix(arg_0));
        map.from((Object)properties.getBatch()).to(arg_0 -> ((FluentConfiguration)configuration).batch(arg_0));
        map.from((Object)properties.getDryRunOutput()).to(arg_0 -> ((FluentConfiguration)configuration).dryRunOutput(arg_0));
        map.from((Object)properties.getErrorOverrides()).to(arg_0 -> ((FluentConfiguration)configuration).errorOverrides(arg_0));
        map.from((Object)properties.getStream()).to(arg_0 -> ((FluentConfiguration)configuration).stream(arg_0));
        map.from((Object)properties.getJdbcProperties()).whenNot(Map::isEmpty).to(arg_0 -> ((FluentConfiguration)configuration).jdbcProperties(arg_0));
        map.from((Object)properties.getKerberosConfigFile()).to(arg_0 -> ((FluentConfiguration)configuration).kerberosConfigFile(arg_0));
        map.from((Object)properties.getOutputQueryResults()).to(arg_0 -> ((FluentConfiguration)configuration).outputQueryResults(arg_0));
        map.from((Object)properties.getSkipExecutingMigrations()).to(arg_0 -> ((FluentConfiguration)configuration).skipExecutingMigrations(arg_0));
        map.from((Object)properties.getIgnoreMigrationPatterns()).whenNot(List::isEmpty).to(ignoreMigrationPatterns -> configuration.ignoreMigrationPatterns(ignoreMigrationPatterns.toArray(new String[0])));
        map.from((Object)properties.getDetectEncoding()).to(arg_0 -> ((FluentConfiguration)configuration).detectEncoding(arg_0));
    }

    private void configureCallbacks(FluentConfiguration configuration, List<Callback> callbacks) {
        if (!callbacks.isEmpty()) {
            configuration.callbacks(callbacks.toArray(new Callback[0]));
        }
    }

    private void configureFlywayCallbacks(FluentConfiguration flyway, List<Callback> callbacks) {
        if (!callbacks.isEmpty()) {
            flyway.callbacks(callbacks.toArray(new Callback[0]));
        }
    }

    private String buildJavaMigrationName(JavaMigration javaMigration) {
        StringBuilder nameBuilder = new StringBuilder();
        if (Objects.nonNull(javaMigration.getVersion())) {
            nameBuilder.append('V').append(javaMigration.getVersion());
        } else {
            nameBuilder.append('R');
        }
        nameBuilder.append("__").append(javaMigration.getDescription());
        return nameBuilder.toString();
    }

    private static class LocationResolver {
        private static final String VENDOR_PLACEHOLDER = "{vendor}";
        private final DataSource dataSource;

        LocationResolver(DataSource dataSource) {
            this.dataSource = dataSource;
        }

        List<String> resolveLocations(List<String> locations) {
            if (this.usesVendorLocation(locations)) {
                DatabaseDriver databaseDriver = this.getDatabaseDriver();
                return this.replaceVendorLocations(locations, databaseDriver);
            }
            return locations;
        }

        private List<String> replaceVendorLocations(List<String> locations, DatabaseDriver databaseDriver) {
            if (databaseDriver == DatabaseDriver.UNKNOWN) {
                return locations;
            }
            String vendor = databaseDriver.getId();
            return locations.stream().map(location -> location.replace(VENDOR_PLACEHOLDER, vendor)).collect(Collectors.toList());
        }

        private DatabaseDriver getDatabaseDriver() {
            try {
                String url = (String)JdbcUtils.extractDatabaseMetaData((DataSource)this.dataSource, DatabaseMetaData::getURL);
                return DatabaseDriver.fromJdbcUrl((String)url);
            }
            catch (MetaDataAccessException ex) {
                throw new IllegalStateException(ex);
            }
        }

        private boolean usesVendorLocation(Collection<String> locations) {
            for (String location : locations) {
                if (!location.contains(VENDOR_PLACEHOLDER)) continue;
                return true;
            }
            return false;
        }
    }

    static class StringOrNumberToMigrationVersionConverter
    implements GenericConverter {
        private static final Set<GenericConverter.ConvertiblePair> CONVERTIBLE_TYPES;

        StringOrNumberToMigrationVersionConverter() {
        }

        public Set<GenericConverter.ConvertiblePair> getConvertibleTypes() {
            return CONVERTIBLE_TYPES;
        }

        public Object convert(@Nullable Object source, @NonNull TypeDescriptor sourceType, @NonNull TypeDescriptor targetType) {
            String value = ObjectUtils.nullSafeToString((Object)source);
            return MigrationVersion.fromVersion((String)value);
        }

        static {
            HashSet<GenericConverter.ConvertiblePair> types = new HashSet<GenericConverter.ConvertiblePair>(2);
            types.add(new GenericConverter.ConvertiblePair(String.class, MigrationVersion.class));
            types.add(new GenericConverter.ConvertiblePair(Number.class, MigrationVersion.class));
            CONVERTIBLE_TYPES = Collections.unmodifiableSet(types);
        }
    }
}

