/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.autoconfig;

import cn.dinodev.spring.data.jdbc.DinoJdbcMappingContext;
import cn.dinodev.spring.data.jdbc.DinoJdbcSimpleTypeHolder;
import cn.dinodev.spring.data.jdbc.mapping.DinoJdbcCustomConversions;
import cn.dinodev.spring.data.sql.dialect.MysqlDialect;
import cn.dinodev.spring.data.sql.dialect.PostgreSQLDialect;
import cn.dinodev.spring.data.sql.dialect.SnakeNamingConversition;
import jakarta.persistence.Table;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.convert.CustomConversions;
import org.springframework.data.convert.ReadingConverter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.data.domain.ManagedTypes;
import org.springframework.data.jdbc.core.convert.JdbcCustomConversions;
import org.springframework.data.jdbc.core.mapping.JdbcMappingContext;
import org.springframework.data.jdbc.core.mapping.JdbcSimpleTypes;
import org.springframework.data.jdbc.repository.config.AbstractJdbcConfiguration;
import org.springframework.data.mapping.model.SimpleTypeHolder;
import org.springframework.data.relational.RelationalManagedTypes;
import org.springframework.data.relational.core.dialect.Dialect;
import org.springframework.data.relational.core.mapping.DefaultNamingStrategy;
import org.springframework.data.relational.core.mapping.NamingStrategy;
import org.springframework.data.util.TypeScanner;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.lang.NonNull;

@Configuration(proxyBeanMethods=false)
public class DinoDataJdbcConfiguration
extends AbstractJdbcConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DinoDataJdbcConfiguration.class);
    private ApplicationContext applicationContext;

    @Bean
    @ConditionalOnMissingBean
    public cn.dinodev.spring.data.sql.dialect.Dialect dialect(JdbcOperations jdbcOperations) {
        return (cn.dinodev.spring.data.sql.dialect.Dialect)jdbcOperations.execute(conn -> {
            DatabaseMetaData metaData = conn.getMetaData();
            cn.dinodev.spring.data.sql.dialect.Dialect dialect = cn.dinodev.spring.data.sql.dialect.Dialect.ofDefault();
            String name = metaData.getDatabaseProductName().toLowerCase(Locale.ENGLISH);
            if (name.contains("mysql") || name.contains("mariadb")) {
                dialect = new MysqlDialect(metaData, new SnakeNamingConversition());
            }
            if (name.contains("postgresql")) {
                dialect = new PostgreSQLDialect(metaData, new SnakeNamingConversition());
            }
            log.warn("Couldn't determine DB Dialect for {}", (Object)name);
            log.info("--->> database: setup dialect:{}", (Object)dialect.getClass().getSimpleName());
            return dialect;
        });
    }

    @NonNull
    public JdbcMappingContext jdbcMappingContext(@NonNull Optional<NamingStrategy> namingStrategy, @NonNull JdbcCustomConversions customConversions, @NonNull RelationalManagedTypes jdbcManagedTypes) {
        DinoJdbcMappingContext mappingContext = new DinoJdbcMappingContext(namingStrategy.orElse(DefaultNamingStrategy.INSTANCE));
        mappingContext.setSimpleTypeHolder(new DinoJdbcSimpleTypeHolder(customConversions.getSimpleTypeHolder()));
        mappingContext.setManagedTypes((ManagedTypes)jdbcManagedTypes);
        return mappingContext;
    }

    @NonNull
    protected List<?> userConverters() {
        Map readingConverters = this.applicationContext.getBeansWithAnnotation(ReadingConverter.class);
        Map writingConverters = this.applicationContext.getBeansWithAnnotation(WritingConverter.class);
        ArrayList converts = new ArrayList(readingConverters.values().stream().toList());
        converts.addAll(writingConverters.values().stream().toList());
        return converts;
    }

    @Bean
    @NonNull
    public JdbcCustomConversions jdbcCustomConversions() {
        try {
            Dialect dialect = (Dialect)this.applicationContext.getBean(Dialect.class);
            SimpleTypeHolder simpleTypeHolder = dialect.simpleTypes().isEmpty() ? JdbcSimpleTypes.HOLDER : new SimpleTypeHolder(dialect.simpleTypes(), JdbcSimpleTypes.HOLDER);
            return new DinoJdbcCustomConversions(CustomConversions.StoreConversions.of((SimpleTypeHolder)simpleTypeHolder, this.storeConverters(dialect)), this.userConverters());
        }
        catch (NoSuchBeanDefinitionException exception) {
            log.warn("No dialect found; CustomConversions will be configured without dialect specific conversions");
            return new JdbcCustomConversions();
        }
    }

    private List<Object> storeConverters(Dialect dialect) {
        ArrayList<Object> converters = new ArrayList<Object>();
        converters.addAll(dialect.getConverters());
        converters.addAll(JdbcCustomConversions.storeConverters());
        return converters;
    }

    @NonNull
    protected Set<Class<?>> scanForEntities(@NonNull String basePackage) {
        Set fromSuper = super.scanForEntities(basePackage);
        if (StringUtils.isBlank((CharSequence)basePackage)) {
            return fromSuper;
        }
        Set jakartaTables = TypeScanner.typeScanner((ClassLoader)AbstractJdbcConfiguration.class.getClassLoader()).forTypesAnnotatedWith(new Class[]{Table.class}).scanPackages(new String[]{basePackage}).collectAsSet();
        jakartaTables.addAll(fromSuper);
        return jakartaTables;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
        super.setApplicationContext(applicationContext);
    }
}

