/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.data.autoconfig;

import cn.dinodev.spring.commons.autoconfig.DinoCommonsAutoConfiguration;
import cn.dinodev.spring.commons.context.ContextHelper;
import cn.dinodev.spring.commons.json.JsonDiscriminatorModule;
import cn.dinodev.spring.data.converts.JacksonCustomerModule;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import jakarta.annotation.PostConstruct;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.ImportAutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.convert.ApplicationConversionService;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Primary;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.ConverterRegistry;
import org.springframework.core.convert.converter.GenericConverter;
import org.springframework.core.convert.support.DefaultConversionService;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.data.projection.SpelAwareProxyProjectionFactory;
import org.springframework.util.Assert;

@Configuration
@ImportAutoConfiguration(value={DinoCommonsAutoConfiguration.class})
@AutoConfigureAfter(value={DinoCommonsAutoConfiguration.class})
public class DinoDataAutoConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DinoDataAutoConfiguration.class);
    @Autowired
    private ContextHelper contextHelper;

    @PostConstruct
    public void check() {
        Assert.notNull((Object)this.contextHelper, (String)"contextHelper should init before DinoDataAutoConfiguration");
    }

    @Bean(value={"jacksonObjectMapper", "objectMapper"})
    @Primary
    @ConditionalOnMissingBean
    public ObjectMapper objectMapper() {
        log.info("--->> json: setup jackson ObjectMapper");
        JsonMapper.Builder builder = JsonMapper.builder();
        builder.disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES});
        builder.enable(new DeserializationFeature[]{DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY});
        builder.enable(new SerializationFeature[]{SerializationFeature.WRITE_ENUMS_USING_TO_STRING});
        builder.enable(new DeserializationFeature[]{DeserializationFeature.READ_ENUMS_USING_TO_STRING});
        builder.enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS});
        builder.enable(new MapperFeature[]{MapperFeature.DEFAULT_VIEW_INCLUSION});
        JsonMapper objectMapper = (JsonMapper)builder.build();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        objectMapper.registerModule((Module)new JacksonCustomerModule());
        objectMapper.registerModule((Module)new JsonDiscriminatorModule());
        return objectMapper;
    }

    @Bean
    @Lazy
    @ConditionalOnMissingBean
    public Gson gson() {
        log.info("--->> json: setup gson");
        return new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    }

    @Bean
    @ConditionalOnMissingBean
    public ProjectionFactory projectionFactory() {
        log.info("--->> projection: setup projection factory");
        return new SpelAwareProxyProjectionFactory();
    }

    @Bean(value={"dataConversionService"})
    public ConversionService dataConversionService(ApplicationContext applicationContext) {
        log.info("--->> conversion: setup dataConversionService");
        DefaultConversionService dataConversionService = new DefaultConversionService();
        ApplicationConversionService.addApplicationConverters((ConverterRegistry)dataConversionService);
        Map genericConverters = applicationContext.getBeansOfType(GenericConverter.class);
        for (Map.Entry kv : genericConverters.entrySet()) {
            log.info("   -- register GenericConverter {}: {}", kv.getKey(), kv.getValue());
            dataConversionService.addConverter((GenericConverter)kv.getValue());
        }
        return dataConversionService;
    }
}

