/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.validation.validator;

import cn.dinodev.spring.commons.validation.constraints.PasswordStrength;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class PasswordStrengthValidator
implements ConstraintValidator<PasswordStrength, String> {
    private PasswordChecker[] checkers;

    public void initialize(PasswordStrength constraintAnnotation) {
        PasswordChecker[] passwordCheckerArray;
        switch (constraintAnnotation.format()) {
            default: {
                throw new MatchException(null, null);
            }
            case NUMERIC: {
                PasswordChecker[] passwordCheckerArray2 = new PasswordChecker[1];
                passwordCheckerArray = passwordCheckerArray2;
                passwordCheckerArray2[0] = PasswordChecker.NUMERIC;
                break;
            }
            case NUMERIC_SPECIAL_CHARACTER: {
                PasswordChecker[] passwordCheckerArray3 = new PasswordChecker[2];
                passwordCheckerArray3[0] = PasswordChecker.NUMERIC;
                passwordCheckerArray = passwordCheckerArray3;
                passwordCheckerArray3[1] = PasswordChecker.SPECIAL_CHARACTER;
                break;
            }
            case LETTER: {
                passwordCheckerArray = PasswordStrengthValidator.letterChecker(constraintAnnotation.letterType());
                break;
            }
            case NUMERIC_LETTER: {
                passwordCheckerArray = (PasswordChecker[])ArrayUtils.addAll((Object[])PasswordStrengthValidator.letterChecker(constraintAnnotation.letterType()), (Object[])new PasswordChecker[]{PasswordChecker.NUMERIC});
                break;
            }
            case LETTER_SPECIAL_CHARACTER: {
                passwordCheckerArray = (PasswordChecker[])ArrayUtils.addAll((Object[])PasswordStrengthValidator.letterChecker(constraintAnnotation.letterType()), (Object[])new PasswordChecker[]{PasswordChecker.SPECIAL_CHARACTER});
                break;
            }
            case NUMERIC_LETTER_SPECIAL_CHARACTER: {
                passwordCheckerArray = (PasswordChecker[])ArrayUtils.addAll((Object[])PasswordStrengthValidator.letterChecker(constraintAnnotation.letterType()), (Object[])new PasswordChecker[]{PasswordChecker.NUMERIC, PasswordChecker.SPECIAL_CHARACTER});
            }
        }
        this.checkers = passwordCheckerArray;
    }

    public boolean isValid(String value, ConstraintValidatorContext context) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return true;
        }
        boolean[] checkHits = new boolean[this.checkers.length];
        Arrays.fill(checkHits, false);
        for (int i = 0; i < value.length(); ++i) {
            char currentChar = value.charAt(i);
            for (int j = 0; j < this.checkers.length; ++j) {
                if (!this.checkers[j].check(currentChar)) continue;
                checkHits[j] = true;
            }
        }
        return !ArrayUtils.contains((boolean[])checkHits, (boolean)false);
    }

    private static PasswordChecker[] letterChecker(PasswordStrength.LetterType type) {
        PasswordChecker[] passwordCheckerArray;
        switch (type) {
            default: {
                throw new MatchException(null, null);
            }
            case ANY: {
                PasswordChecker[] passwordCheckerArray2 = new PasswordChecker[1];
                passwordCheckerArray = passwordCheckerArray2;
                passwordCheckerArray2[0] = PasswordChecker.LETTER;
                break;
            }
            case LOWER: {
                PasswordChecker[] passwordCheckerArray3 = new PasswordChecker[1];
                passwordCheckerArray = passwordCheckerArray3;
                passwordCheckerArray3[0] = PasswordChecker.LETTER_LOWER;
                break;
            }
            case UPPER: {
                PasswordChecker[] passwordCheckerArray4 = new PasswordChecker[1];
                passwordCheckerArray = passwordCheckerArray4;
                passwordCheckerArray4[0] = PasswordChecker.LETTER_UPPER;
                break;
            }
            case BOTH: {
                PasswordChecker[] passwordCheckerArray5 = new PasswordChecker[2];
                passwordCheckerArray5[0] = PasswordChecker.LETTER_LOWER;
                passwordCheckerArray = passwordCheckerArray5;
                passwordCheckerArray5[1] = PasswordChecker.LETTER_UPPER;
            }
        }
        return passwordCheckerArray;
    }

    private static enum PasswordChecker {
        NUMERIC{

            @Override
            public boolean check(char ch) {
                return Character.isDigit(ch);
            }
        }
        ,
        LETTER{

            @Override
            public boolean check(char ch) {
                return Character.isLowerCase(ch) || Character.isUpperCase(ch);
            }
        }
        ,
        LETTER_LOWER{

            @Override
            public boolean check(char ch) {
                return Character.isLowerCase(ch);
            }
        }
        ,
        LETTER_UPPER{

            @Override
            public boolean check(char ch) {
                return Character.isUpperCase(ch);
            }
        }
        ,
        SPECIAL_CHARACTER{

            @Override
            public boolean check(char ch) {
                return Arrays.binarySearch(SYMBOLS, ch) >= 0;
            }
        };

        private static final char[] SYMBOLS;

        public abstract boolean check(char var1);

        static {
            SYMBOLS = ")!@#$%^&*()".toCharArray();
            Arrays.sort(SYMBOLS);
        }
    }
}

