/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import cn.dinodev.spring.commons.promise.Defer;
import cn.dinodev.spring.commons.promise.Promise;
import cn.dinodev.spring.commons.utils.TypeUtils;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import lombok.Generated;
import org.apache.commons.lang3.ThreadUtils;

public final class TaskUtils {
    public static void exec(Runnable task, int attempts) {
        TaskUtils.exec(task, attempts, null);
    }

    public static void exec(Runnable task, int attempts, Duration nap) {
        while (attempts > 0) {
            --attempts;
            try {
                task.run();
                return;
            }
            catch (Exception e) {
                TaskUtils.nap(nap);
            }
        }
    }

    public static <T> void exec(Consumer<T> task, T param, int attempts) {
        TaskUtils.exec(task, param, attempts, null);
    }

    public static <T> void exec(Consumer<T> task, T param, int attempts, Duration nap) {
        TaskUtils.exec(() -> task.accept(param), attempts, nap);
    }

    public static <T, U> void exec(BiConsumer<T, U> task, T paramFirst, U paramSecond, int attempts) {
        TaskUtils.exec(task, paramFirst, paramSecond, attempts, null);
    }

    public static <T, U> void exec(BiConsumer<T, U> task, T paramFirst, U paramSecond, int attempts, Duration nap) {
        TaskUtils.exec(() -> task.accept(paramFirst, paramSecond), attempts, nap);
    }

    @SafeVarargs
    public static <R> Promise<R> exec(Callable<R> task, Predicate<R> checker, int attempts, Class<? extends RuntimeException> ... throwOutExceptions) {
        return TaskUtils.exec(task, checker, attempts, null, throwOutExceptions);
    }

    @SafeVarargs
    public static <R> Promise<R> exec(Callable<R> task, Predicate<R> checker, int attempts, Duration nap, Class<? extends RuntimeException> ... throwOutExceptions) {
        while (attempts > 0) {
            block5: {
                --attempts;
                try {
                    R ret = task.call();
                    if (checker.test(ret)) {
                        return Defer.resolve(ret);
                    }
                }
                catch (Exception t) {
                    if (!Objects.isNull(throwOutExceptions) && TypeUtils.isInstanceOfAny(t, throwOutExceptions)) {
                        throw (RuntimeException)TypeUtils.castNonNull(t);
                    }
                    if (attempts != 0) break block5;
                    return Defer.fail(t);
                }
            }
            TaskUtils.nap(nap);
        }
        return Defer.fail();
    }

    @SafeVarargs
    public static <T, R> Promise<R> exec(Function<T, R> task, T param, Predicate<R> checker, int attempts, Class<? extends RuntimeException> ... throwOutExceptions) {
        return TaskUtils.exec(task, param, checker, attempts, null, throwOutExceptions);
    }

    @SafeVarargs
    public static <T, R> Promise<R> exec(Function<T, R> task, T param, Predicate<R> checker, int attempts, Duration nap, Class<? extends RuntimeException> ... throwOutExceptions) {
        return TaskUtils.exec(() -> task.apply(param), checker, attempts, nap, throwOutExceptions);
    }

    @SafeVarargs
    public static <T, U, R> Promise<R> exec(BiFunction<T, U, R> task, T paramFirst, U paramSecond, Predicate<R> checker, int attempts, Class<? extends RuntimeException> ... throwOutExceptions) {
        return TaskUtils.exec(task, paramFirst, paramSecond, checker, attempts, null, throwOutExceptions);
    }

    @SafeVarargs
    public static <T, U, R> Promise<R> exec(BiFunction<T, U, R> task, T paramFirst, U paramSecond, Predicate<R> checker, int attempts, Duration nap, Class<? extends RuntimeException> ... throwOutExceptions) {
        return TaskUtils.exec(() -> task.apply(paramFirst, paramSecond), checker, attempts, nap, throwOutExceptions);
    }

    public static boolean nap(Duration nap) {
        if (Objects.isNull(nap)) {
            return true;
        }
        try {
            ThreadUtils.sleep((Duration)nap);
            return true;
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    @Generated
    private TaskUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

