/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import jakarta.annotation.Nonnull;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ReflectionUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Map<Class<?>, List<Field>> CLASS_FIELD_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_TYPE_MAP = new IdentityHashMap(8);

    public static Object getFieldValue(Object entity, String fieldName) throws IllegalAccessException {
        Class<?> cls = entity.getClass();
        Map<String, Field> fieldMaps = ReflectionUtils.getFieldMap(cls);
        try {
            Field field = fieldMaps.get(fieldName);
            return field.get(entity);
        }
        catch (ReflectiveOperationException e) {
            log.error("Error: Cannot read field in {}. ", (Object)cls.getSimpleName(), (Object)e);
            IllegalAccessException exception = new IllegalAccessException(e.getMessage());
            exception.initCause(e);
            throw exception;
        }
    }

    public static Class<?> getSuperClassGenericType(Class<?> clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.warn("Warn: {}'s superclass not ParameterizedType", (Object)clazz.getSimpleName());
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.warn("Warn: Index: {}, Size of %s's Parameterized Type: {} .", new Object[]{index, clazz.getSimpleName(), params.length});
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.warn("Warn: {} not set the actual class on superclass generic parameter", (Object)clazz.getSimpleName());
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        List<Field> fieldList = ReflectionUtils.getFieldList(clazz);
        return CollectionUtils.isNotEmpty(fieldList) ? fieldList.stream().collect(Collectors.toMap(Field::getName, field -> field)) : Collections.emptyMap();
    }

    public static List<Field> getFieldList(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return Collections.emptyList();
        }
        return CLASS_FIELD_CACHE.computeIfAbsent(clazz, k -> {
            Field[] fields = k.getDeclaredFields();
            ArrayList<Field> superFields = new ArrayList<Field>();
            for (Class currentClass = k.getSuperclass(); currentClass != null; currentClass = currentClass.getSuperclass()) {
                Field[] declaredFields = currentClass.getDeclaredFields();
                Collections.addAll(superFields, declaredFields);
            }
            Map<String, Field> fieldMap = ReflectionUtils.excludeOverrideSuperField(fields, superFields);
            return fieldMap.values().stream().filter(f -> !Modifier.isStatic(f.getModifiers())).filter(f -> !Modifier.isTransient(f.getModifiers())).collect(Collectors.toList());
        });
    }

    public static Map<String, Field> excludeOverrideSuperField(Field[] fields, List<Field> superFieldList) {
        Map fieldMap = Stream.of(fields).collect(Collectors.toMap(Field::getName, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        superFieldList.stream().filter(field -> !fieldMap.containsKey(field.getName())).forEach(f -> fieldMap.put(f.getName(), f));
        return fieldMap;
    }

    public static boolean isPrimitiveOrWrapper(@Nonnull Class<?> clazz) {
        return clazz.isPrimitive() || PRIMITIVE_WRAPPER_TYPE_MAP.containsKey(clazz);
    }

    @Generated
    private ReflectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    static {
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Boolean.class, Boolean.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Byte.class, Byte.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Character.class, Character.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Double.class, Double.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Float.class, Float.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Integer.class, Integer.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Long.class, Long.TYPE);
        PRIMITIVE_WRAPPER_TYPE_MAP.put(Short.class, Short.TYPE);
    }
}

