/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public final class NamingUtils {
    private static final char UNDER_SCORE_CHAR = '_';

    public static String toCamel(String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            return name;
        }
        StringBuilder result = new StringBuilder();
        boolean nextIsUpper = false;
        if (name.length() > 1 && name.charAt(1) == '_') {
            result.append(Character.toUpperCase(name.charAt(0)));
        } else {
            result.append(Character.toLowerCase(name.charAt(0)));
        }
        for (int i = 1; i < name.length(); ++i) {
            char currentChar = name.charAt(i);
            if (currentChar == '_') {
                nextIsUpper = true;
                continue;
            }
            if (nextIsUpper) {
                result.append(Character.toUpperCase(currentChar));
                nextIsUpper = false;
                continue;
            }
            result.append(Character.toLowerCase(currentChar));
        }
        return result.toString();
    }

    public static String toSnake(String name) {
        if (name == null) {
            return name;
        }
        int length = name.length();
        StringBuilder result = new StringBuilder(length * 2);
        int resultLength = 0;
        boolean wasPrevTranslated = false;
        for (int i = 0; i < length; ++i) {
            char currentChar = name.charAt(i);
            if (i <= 0 && currentChar == '_') continue;
            if (Character.isUpperCase(currentChar)) {
                if (!wasPrevTranslated && resultLength > 0 && result.charAt(resultLength - 1) != '_') {
                    result.append('_');
                    ++resultLength;
                }
                currentChar = Character.toLowerCase(currentChar);
                wasPrevTranslated = true;
            } else {
                wasPrevTranslated = false;
            }
            result.append(currentChar);
            ++resultLength;
        }
        return resultLength > 0 ? result.toString() : name;
    }

    public static String methodToProperty(String name) {
        boolean hasSecondCharLowerCase;
        if (((String)name).startsWith("is")) {
            name = ((String)name).substring(2);
        } else if (((String)name).startsWith("get") || ((String)name).startsWith("set")) {
            name = ((String)name).substring(3);
        } else {
            throw new IllegalArgumentException("Error parsing property name '" + (String)name + "'.  Didn't start with 'is', 'get' or 'set'.");
        }
        boolean bl = hasSecondCharLowerCase = ((String)name).length() > 1 && !Character.isUpperCase(((String)name).charAt(1));
        if (((String)name).length() == 1 || hasSecondCharLowerCase) {
            name = ((String)name).substring(0, 1).toLowerCase(Locale.ENGLISH) + ((String)name).substring(1);
        }
        return name;
    }

    @Generated
    private NamingUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

