/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import cn.dinodev.spring.commons.utils.NamingUtils;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.reflect.MethodUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LambdaUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LambdaUtils.class);
    private static final Map<String, String> FUNC_PROPERTY_CACHE = new ConcurrentHashMap<String, String>();

    public static <T, R> String methodToProperty(Function<T, R> getterFn) {
        Class<?> clazz = getterFn.getClass();
        String name = clazz.getName();
        if (log.isDebugEnabled()) {
            log.debug("Processing getter function: {}", (Object)name);
        }
        return Optional.ofNullable(FUNC_PROPERTY_CACHE.get(name)).orElseGet(() -> {
            SerializedLambda lambda = LambdaUtils.getSerializedLambda(getterFn);
            if (lambda == null) {
                throw new IllegalArgumentException("getterFn is not lambda");
            }
            return NamingUtils.methodToProperty(lambda.getImplMethodName());
        });
    }

    public static <T, R> String methodToProperty(BiConsumer<T, R> setterFn) {
        Class<?> clazz = setterFn.getClass();
        String name = clazz.getName();
        if (log.isDebugEnabled()) {
            log.debug("Processing setter function: {}", (Object)name);
        }
        return Optional.ofNullable(FUNC_PROPERTY_CACHE.get(name)).orElseGet(() -> {
            SerializedLambda lambda = LambdaUtils.getSerializedLambda(setterFn);
            if (lambda == null) {
                throw new IllegalArgumentException("setterFn is not lambda");
            }
            return NamingUtils.methodToProperty(lambda.getImplMethodName());
        });
    }

    public static SerializedLambda getSerializedLambda(Object fn) {
        try {
            return (SerializedLambda)MethodUtils.invokeMethod((Object)fn, (boolean)true, (String)"writeReplace");
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6SerializedLambda\u5f02\u5e38, class=" + fn.getClass().getSimpleName(), (Throwable)e);
            return null;
        }
    }

    public static <T> void forEach(Iterable<? extends T> elements, BiConsumer<Integer, ? super T> action) {
        LambdaUtils.forEach(0, elements, action);
    }

    public static <T> void forEach(int startIndex, Iterable<? extends T> elements, BiConsumer<Integer, ? super T> action) {
        Objects.requireNonNull(elements);
        Objects.requireNonNull(action);
        if (startIndex < 0) {
            startIndex = 0;
        }
        int index = 0;
        for (T element : elements) {
            if (++index <= startIndex) continue;
            action.accept(index - 1, (Integer)element);
        }
    }

    @Generated
    private LambdaUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

