/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import jakarta.servlet.http.HttpServletRequest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class IpUtils {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(IpUtils.class);

    private IpUtils() {
        throw new IllegalStateException("Utility class");
    }

    public static String getIpAddr(HttpServletRequest request) {
        String ip = null;
        try {
            ip = request.getHeader("x-forwarded-for");
            ip = (String)StringUtils.getIfEmpty((CharSequence)ip, () -> request.getHeader("Proxy-Client-IP"));
            ip = (String)StringUtils.getIfEmpty((CharSequence)ip, () -> request.getHeader("WL-Proxy-Client-IP"));
            ip = (String)StringUtils.getIfEmpty((CharSequence)ip, () -> request.getHeader("HTTP_CLIENT_IP"));
            ip = (String)StringUtils.getIfEmpty((CharSequence)ip, () -> request.getHeader("HTTP_X_FORWARDED_FOR"));
            ip = (String)StringUtils.getIfEmpty((CharSequence)ip, () -> ((HttpServletRequest)request).getRemoteAddr());
        }
        catch (Exception e) {
            log.error("get ip error occurred ", (Throwable)e);
        }
        if (StringUtils.isNotEmpty((CharSequence)ip)) {
            ip = StringUtils.split((String)ip, (char)',')[0];
        }
        return ip;
    }
}

