/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.codec.digest.HmacUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EncryptUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EncryptUtil.class);
    private static final String HMAC_SHA256 = "HmacSHA256";
    private static final String HMAC_MD5 = "HmacMD5";

    public static String md5Salt(String source, String salt) {
        try {
            SecretKeySpec secretKey = new SecretKeySpec(salt.getBytes(StandardCharsets.UTF_8), HMAC_MD5);
            Mac mac = Mac.getInstance(HMAC_MD5);
            mac.init(secretKey);
            return DigestUtils.md5Hex((byte[])HmacUtils.updateHmac((Mac)mac, (String)source).doFinal());
        }
        catch (Exception e) {
            log.error("MD5 salt encryption failed", (Throwable)e);
            return null;
        }
    }

    public static String genUserSign(String osKey, long timestamp, String uid, String userSecretKey) {
        try {
            Mac hmacSha256 = Mac.getInstance(HMAC_SHA256);
            byte[] keyBytes = userSecretKey.getBytes(StandardCharsets.UTF_8);
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, HMAC_SHA256));
            String encryptStr = DigestUtils.md5Hex((byte[])hmacSha256.doFinal((uid + timestamp + osKey).getBytes("UTF-8")));
            return Base64.getEncoder().encodeToString(encryptStr.getBytes());
        }
        catch (Exception e) {
            log.error("User sign generation failed", (Throwable)e);
            return null;
        }
    }

    public static boolean checkUserSign(String osKey, long timestamp, String uid, String userSecretKey, String sign) {
        try {
            sign = URLDecoder.decode(sign, StandardCharsets.UTF_8);
            Mac hmacSha256 = Mac.getInstance(HMAC_SHA256);
            byte[] keyBytes = userSecretKey.getBytes(StandardCharsets.UTF_8);
            hmacSha256.init(new SecretKeySpec(keyBytes, 0, keyBytes.length, HMAC_SHA256));
            String encryptStr = DigestUtils.md5Hex((byte[])hmacSha256.doFinal((uid + timestamp + osKey).getBytes(StandardCharsets.UTF_8)));
            return sign.equals(Base64.getEncoder().encodeToString(encryptStr.getBytes()));
        }
        catch (Exception e) {
            log.error("User sign check failed", (Throwable)e);
            return false;
        }
    }

    @Generated
    private EncryptUtil() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

