/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Consumer;
import lombok.Generated;

public final class BatchUtils {
    public static <E> void executeBatch(Iterable<E> list, int batchSize, Consumer<Collection<E>> consumer) {
        if (batchSize <= 0) {
            throw new IllegalArgumentException("batchSize must not be less than one");
        }
        if (list == null) {
            return;
        }
        Iterator<E> it = list.iterator();
        ArrayList<E> subList = new ArrayList<E>(batchSize);
        while (it.hasNext()) {
            subList.add(it.next());
            if (subList.size() != batchSize) continue;
            consumer.accept(subList);
            subList.clear();
        }
        if (!subList.isEmpty()) {
            consumer.accept(subList);
            subList.clear();
        }
    }

    @Generated
    private BatchUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

