/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import lombok.Generated;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
@Async
public class AsyncWorker {
    public void exec(Runnable task) {
        task.run();
    }

    public <R> Future<R> exec(Callable<R> task) {
        FutureTask<R> futureTask = new FutureTask<R>(task);
        futureTask.run();
        return futureTask;
    }

    public <T> void exec(Consumer<T> task, T param) {
        task.accept(param);
    }

    public <T, R> Future<R> exec(Function<T, R> task, T param) {
        FutureTask<Object> futureTask = new FutureTask<Object>(() -> task.apply(param));
        futureTask.run();
        return futureTask;
    }

    public <T, U> void exec(BiConsumer<T, U> task, T paramFirst, U paramSecond) {
        task.accept(paramFirst, paramSecond);
    }

    public <T, U, R> Future<R> exec(BiFunction<T, U, R> task, T paramFirst, U paramSecond) {
        FutureTask<Object> futureTask = new FutureTask<Object>(() -> task.apply(paramFirst, paramSecond));
        futureTask.run();
        return futureTask;
    }

    @Generated
    public AsyncWorker() {
    }
}

