/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.utils;

import cn.dinodev.spring.commons.utils.TypeUtils;
import org.springframework.asm.ClassWriter;
import org.springframework.asm.MethodVisitor;
import org.springframework.asm.Type;
import org.springframework.cglib.core.ReflectUtils;

public interface AsmUtils {
    public static <T, U extends T> Class<U> defineGenericClass(String className, Class<T> superClass, Class<?> parameterClass) throws Exception {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return (Class)TypeUtils.cast(classLoader.loadClass(className));
        }
        catch (ClassNotFoundException e) {
            ClassNotFoundException classNotFoundException = e;
            String param1Name = Type.getInternalName(parameterClass);
            String superClassName = Type.getInternalName(superClass);
            String sigStr = "L" + superClassName + "<+L" + param1Name + ";>;";
            ClassWriter cw = new ClassWriter(2);
            cw.visit(55, 49, className.replace('.', '/'), sigStr, superClassName, null);
            MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
            mv.visitCode();
            mv.visitVarInsn(25, 0);
            mv.visitMethodInsn(183, superClassName, "<init>", "()V", false);
            mv.visitInsn(177);
            mv.visitMaxs(1, 1);
            mv.visitEnd();
            cw.visitEnd();
            byte[] code = cw.toByteArray();
            Class newClass = ReflectUtils.defineClass((String)className, (byte[])code, (ClassLoader)classLoader);
            return (Class)TypeUtils.cast(newClass);
        }
    }

    public static String className(Class<?> baseClass, String postfix) {
        return baseClass.getName() + "$" + postfix;
    }

    public static String className(Class<?> baseClass, Class<?> typeClass) {
        return String.valueOf(baseClass) + "$" + typeClass.getSimpleName();
    }
}

