/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.response;

import cn.dinodev.spring.commons.response.DefaultStatus;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.util.Assert;

public interface Status {
    public int getCode();

    public String getMsg();

    public Status withMsg(@Nonnull String var1);

    public Status withMsg(@Nonnull String var1, Object ... var2);

    public static Status ok() {
        return CODE.OK;
    }

    public static Status ok(@Nonnull String msg) {
        return new DefaultStatus(0, msg);
    }

    public static Status fail(@Nonnull String msg) {
        return Status.fail(CODE.ERROR.getCode(), msg);
    }

    public static Status fail(@Nonnull String msg, Object ... args) {
        String formatedMsg = MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage();
        Objects.requireNonNull(formatedMsg);
        return Status.fail(CODE.ERROR.getCode(), formatedMsg);
    }

    public static Status fail(int code, @Nonnull String msg) {
        Assert.isTrue((code > 0 ? 1 : 0) != 0, (String)"code must great than 0");
        return new DefaultStatus(code, msg);
    }

    public static Status fail(int code, @Nonnull String msg, Object ... args) {
        Assert.isTrue((code > 0 ? 1 : 0) != 0, (String)"code must great than 0");
        return new DefaultStatus(code, MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage());
    }

    public static Status invalidParam(@Nonnull String msg) {
        return Status.fail(CODE.FAIL_INVALID_PARAM.getCode(), msg);
    }

    public static Status invalidParam(@Nonnull String msg, Object ... args) {
        String formatedMsg = MessageFormatter.arrayFormat((String)msg, (Object[])args).getMessage();
        Objects.requireNonNull(formatedMsg);
        return Status.fail(CODE.FAIL_INVALID_PARAM.getCode(), formatedMsg);
    }

    @Schema(name="CODE", title="\u54cd\u5e94\u7684\u72b6\u6001\u7801")
    public static enum CODE implements Status
    {
        OK(0, "Success"),
        ERROR(1, "\u64cd\u4f5c\u5931\u8d25"),
        FAIL_EXISTS(10, "\u5df2\u5b58\u5728"),
        FAIL_LOGIN(600, "\u767b\u5f55\u5931\u8d25"),
        FAIL_LOGIN_DENNY(601, "\u8d26\u53f7\u4e0d\u5141\u8bb8\u767b\u5f55"),
        FAIL_NOT_LOGIN(602, "\u672a\u767b\u5f55"),
        FAIL_INVALID_PASSWORD(610, "\u8d26\u53f7\u6216\u5bc6\u7801\u9519\u8bef"),
        FAIL_INVALID_PHONE(611, "\u624b\u673a\u53f7\u9519\u8bef"),
        FAIL_INVALID_CAPTCHA(612, "\u9a8c\u8bc1\u7801\u4e0d\u6b63\u786e"),
        FAIL_INVALID_AUTH_TOKEN(630, "token\u4e0d\u6b63\u786e"),
        FAIL_TOKEN_LOGIN_ANOTHER_DEVICE(631, "\u5df2\u7ecf\u5728\u53e6\u4e00\u53f0\u8bbe\u5907\u4e0a\u767b\u5f55\u4e86"),
        FAIL_INVALID_REFRESH_TOKEN(640, "refresh token\u5df2\u7ecf\u8fc7\u671f"),
        WARN_PARTIAL_SUCCESS(1001, "\u90e8\u5206\u6210\u529f"),
        WARN_PERFORMANCE_ISSUE(1002, "\u6f5c\u5728\u7684\u6027\u80fd\u95ee\u9898"),
        FAIL_INVALID_PARAM(4000, "\u8bf7\u6c42\u53c2\u6570\u9519\u8bef"),
        FAIL_NO_PERMISSION(4003, "\u65e0\u6743\u6267\u884c\u8be5\u64cd\u4f5c"),
        FAIL_AUTH(4003, "\u6743\u9650\u8ba4\u8bc1\u5931\u8d25"),
        FAIL_NOT_FOUND(4004, "\u8d44\u6e90\u4e0d\u5b58\u5728"),
        FAIL_VALIDATION(4005, "\u6570\u636e\u6821\u9a8c\u4e0d\u901a\u8fc7"),
        FAIL_OPERATION(4006, "\u64cd\u4f5c\u6267\u884c\u5931\u8d25"),
        FAIL_INVALID_STAUS(4010, "\u8d44\u6e90\u72b6\u6001\u4e0d\u6b63\u786e"),
        FAIL_REQUEST_TIMEOUT(4008, "\u8bf7\u6c42\u8fde\u63a5\u8d85\u65f6"),
        FAIL_TENANT_NOT_EXIST(4041, "\u79df\u6237\u4e0d\u5b58\u5728"),
        FAIL_USER_NOT_EXIST(4042, "\u7528\u6237\u4e0d\u5b58\u5728"),
        FAIL_EXCEPTION(5000, "\u7cfb\u7edf\u5f02\u5e38"),
        FAIL_PERSISTENT_EXCEPTION(5001, "\u6301\u4e45\u5316\u5931\u8d25"),
        FAIL_QUERY_EXCEPTION(5002, "\u67e5\u8be2\u5931\u8d25"),
        FAIL_SERVICE_UNAVAILABLE(5003, "\u670d\u52a1\u4e0d\u53ef\u7528"),
        FAIL_IO_EXCEPTION(5004, "\u7cfb\u7edfIO\u5f02\u5e38"),
        CACHE_EMPTY(9999, "\u7f13\u5b58\u6e05\u7a7a");

        private final int iCode;
        private final String msg;

        @Override
        public int getCode() {
            return this.iCode;
        }

        @Override
        public String getMsg() {
            return this.msg;
        }

        @Override
        public Status withMsg(@Nonnull String msg) {
            return Status.fail(this.iCode, msg);
        }

        @Override
        public Status withMsg(@Nonnull String msg, Object ... args) {
            return Status.fail(this.iCode, msg, args);
        }

        @Generated
        private CODE(int iCode, String msg) {
            this.iCode = iCode;
            this.msg = msg;
        }
    }
}

