/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.response;

import cn.dinodev.spring.commons.response.Response;
import cn.dinodev.spring.commons.response.Status;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.function.Function;
import lombok.Generated;

@Schema(description="restApi\u6ed1\u52a8\u7a97\u53e3\u54cd\u5e94")
public class ScrollResponse<T>
extends Response<Collection<? extends T>> {
    @Schema(description="\u662f\u5426\u6709\u66f4\u591a\u6570\u636e")
    private Boolean hasMore;
    @Schema(description="\u672c\u6b21\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u6761\u6570")
    private Integer count;
    @Schema(description="\u4e0b\u6b21\u8bf7\u6c42\u6e38\u6807")
    private String cursor;

    protected ScrollResponse(int code, String msg) {
        super(code, msg);
        this.count = 0;
        this.hasMore = null;
    }

    protected ScrollResponse(Collection<? extends T> list, @Nullable String nextCursor, boolean hasMore) {
        super.setData(list);
        this.count = list == null ? 0 : list.size();
        this.cursor = nextCursor;
        this.hasMore = hasMore;
    }

    public ScrollResponse<T> set(Collection<? extends T> list, @Nullable String nextCursor, boolean hasMore) {
        this.setData(list);
        this.cursor = nextCursor;
        this.hasMore = hasMore;
        return this;
    }

    @Override
    public Response<Collection<? extends T>> setData(Collection<? extends T> list) {
        this.count = list == null ? 0 : list.size();
        return super.setData(list);
    }

    public static <T> ScrollResponse<T> success(@Nonnull Collection<? extends T> list, @Nullable String nextCursor, boolean hasMore) {
        return new ScrollResponse<T>(list, nextCursor, hasMore);
    }

    public static <T, S> ScrollResponse<T> success(@Nonnull Collection<S> list, @Nonnull Function<Collection<S>, Collection<? extends T>> converter, @Nullable String nextCursor, boolean hasMore) {
        return new ScrollResponse<T>(converter.apply(list), nextCursor, hasMore);
    }

    public static <T> ScrollResponse<T> successWithMore(@Nonnull Collection<? extends T> list, @Nonnull String nextCursor) {
        return new ScrollResponse<T>(list, nextCursor, true);
    }

    public static <T> ScrollResponse<T> successWithNoMore(@Nonnull Collection<? extends T> list) {
        return new ScrollResponse<T>(list, null, false);
    }

    public static <T> ScrollResponse<T> failPage(String msg) {
        return new ScrollResponse<T>(Status.CODE.ERROR.getCode(), msg);
    }

    public static <T> ScrollResponse<T> failPage(Status status) {
        return new ScrollResponse<T>(status.getCode(), status.getMsg());
    }

    @Generated
    public Boolean getHasMore() {
        return this.hasMore;
    }

    @Generated
    public Integer getCount() {
        return this.count;
    }

    @Generated
    public String getCursor() {
        return this.cursor;
    }

    @Generated
    public ScrollResponse<T> setHasMore(Boolean hasMore) {
        this.hasMore = hasMore;
        return this;
    }

    @Generated
    public ScrollResponse<T> setCount(Integer count) {
        this.count = count;
        return this;
    }

    @Generated
    public ScrollResponse<T> setCursor(String cursor) {
        this.cursor = cursor;
        return this;
    }

    @Override
    @Generated
    public String toString() {
        return "ScrollResponse(hasMore=" + this.getHasMore() + ", count=" + this.getCount() + ", cursor=" + this.getCursor() + ")";
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScrollResponse)) {
            return false;
        }
        ScrollResponse other = (ScrollResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$hasMore = this.getHasMore();
        Boolean other$hasMore = other.getHasMore();
        if (this$hasMore == null ? other$hasMore != null : !((Object)this$hasMore).equals(other$hasMore)) {
            return false;
        }
        Integer this$count = this.getCount();
        Integer other$count = other.getCount();
        if (this$count == null ? other$count != null : !((Object)this$count).equals(other$count)) {
            return false;
        }
        String this$cursor = this.getCursor();
        String other$cursor = other.getCursor();
        return !(this$cursor == null ? other$cursor != null : !this$cursor.equals(other$cursor));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ScrollResponse;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Boolean $hasMore = this.getHasMore();
        result = result * 59 + ($hasMore == null ? 43 : ((Object)$hasMore).hashCode());
        Integer $count = this.getCount();
        result = result * 59 + ($count == null ? 43 : ((Object)$count).hashCode());
        String $cursor = this.getCursor();
        result = result * 59 + ($cursor == null ? 43 : $cursor.hashCode());
        return result;
    }
}

