/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.request;

import cn.dinodev.spring.commons.request.SortReq;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Min;
import lombok.Generated;
import org.springdoc.core.annotations.ParameterObject;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.lang.NonNull;

@ParameterObject
public class PageReq {
    @Min(value=0L)
    @Parameter(description="\u9875\u7801\uff0c\u4ece0\u5f00\u59cb (0..N)", schema=@Schema(type="integer", defaultValue="0"))
    private @Min(value=0L) Integer pn = 0;
    @Min(value=1L)
    @Parameter(description="\u9875\u957f\uff0c\u6700\u5c0f\u4e3a1", schema=@Schema(type="integer", defaultValue="10"))
    private @Min(value=1L) Integer pl = 10;

    public Pageable pageable() {
        return PageRequest.of((int)this.pn, (int)this.pl);
    }

    public Pageable pageable(SortReq sortReq) {
        return PageRequest.of((int)this.pn, (int)this.pl, (Sort)(sortReq == null ? Sort.unsorted() : sortReq.sortable()));
    }

    public Pageable pageable(SortReq sortReq, String prefix) {
        Sort sort = Sort.unsorted();
        if (sortReq != null) {
            sort = sortReq.sortable(prefix);
        }
        return PageRequest.of((int)this.pn, (int)this.pl, (Sort)sort);
    }

    public Pageable pageable(@NonNull Sort sort) {
        return PageRequest.of((int)this.pn, (int)this.pl, (Sort)sort);
    }

    @Generated
    public Integer getPn() {
        return this.pn;
    }

    @Generated
    public Integer getPl() {
        return this.pl;
    }

    @Generated
    public void setPn(Integer pn) {
        this.pn = pn;
    }

    @Generated
    public void setPl(Integer pl) {
        this.pl = pl;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageReq)) {
            return false;
        }
        PageReq other = (PageReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Integer this$pn = this.getPn();
        Integer other$pn = other.getPn();
        if (this$pn == null ? other$pn != null : !((Object)this$pn).equals(other$pn)) {
            return false;
        }
        Integer this$pl = this.getPl();
        Integer other$pl = other.getPl();
        return !(this$pl == null ? other$pl != null : !((Object)this$pl).equals(other$pl));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof PageReq;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Integer $pn = this.getPn();
        result = result * 59 + ($pn == null ? 43 : ((Object)$pn).hashCode());
        Integer $pl = this.getPl();
        result = result * 59 + ($pl == null ? 43 : ((Object)$pl).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "PageReq(pn=" + this.getPn() + ", pl=" + this.getPl() + ")";
    }

    @Generated
    public PageReq(Integer pn, Integer pl) {
        this.pn = pn;
        this.pl = pl;
    }

    @Generated
    public PageReq() {
    }
}

