/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.promise;

import cn.dinodev.spring.commons.promise.AbstractPromise;
import cn.dinodev.spring.commons.promise.Deferred;
import cn.dinodev.spring.commons.promise.Promise;

public class DeferredObject<D>
extends AbstractPromise<D>
implements Deferred<D> {
    @Override
    public Deferred<D> resolve(D resolve) {
        this.lock.lock();
        try {
            if (!this.isPending()) {
                throw new IllegalStateException("Deferred object already finished, cannot resolve again");
            }
            this.promiseState = Promise.State.RESOLVED;
            this.resolveResult = resolve;
            try {
                this.triggerDone(resolve);
            }
            finally {
                this.triggerAlways(this.promiseState, resolve, null);
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    @Override
    public Deferred<D> reject(Throwable reject) {
        this.lock.lock();
        try {
            if (!this.isPending()) {
                throw new IllegalStateException("Deferred object already finished, cannot reject again");
            }
            this.promiseState = Promise.State.REJECTED;
            this.rejectResult = reject;
            try {
                this.triggerFail(reject);
            }
            finally {
                this.triggerAlways(this.promiseState, null, reject);
            }
        }
        finally {
            this.lock.unlock();
        }
        return this;
    }

    @Override
    public Promise<D> promise() {
        return this;
    }
}

