/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.projection;

import cn.dinodev.spring.commons.bean.BeanMetaUtils;
import cn.dinodev.spring.commons.bean.Property;
import cn.dinodev.spring.commons.function.Functions;
import cn.dinodev.spring.commons.json.JsonViewUtils;
import cn.dinodev.spring.commons.utils.TypeUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.convert.ConversionService;

public class PropertyProjector<S, T> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PropertyProjector.class);
    private static final String SOURCE_PROPERTY_NOT_FOUND = "source property not found: ";
    private final Class<S> sourceClass;
    private final Class<T> targetClass;
    private ConversionService conversionService;
    private final List<PropertyCopier> copiers = new ArrayList<PropertyCopier>(4);

    public PropertyProjector(@Nonnull Class<S> sourceClass, @Nonnull Class<T> targetClass) {
        this(sourceClass, targetClass, null);
    }

    public PropertyProjector(@Nonnull Class<S> sourceClass, @Nonnull Class<T> targetClass, @Nullable ConversionService conversionService) {
        this.sourceClass = sourceClass;
        this.targetClass = targetClass;
        this.conversionService = conversionService;
    }

    @Nullable
    public ConversionService getConversionService() {
        return this.conversionService;
    }

    public void setConversionService(@Nullable ConversionService conversionService) {
        this.conversionService = conversionService;
    }

    public T copy(S source) {
        T target = TypeUtils.newInstance(this.targetClass);
        return this.copy(source, target);
    }

    public T copy(S source, Class<?> activeJsonView) {
        T target = TypeUtils.newInstance(this.targetClass);
        return this.copy(source, target, activeJsonView);
    }

    public T copy(S source, T target) {
        for (PropertyCopier copier : this.copiers) {
            copier.copy(source, target);
        }
        return target;
    }

    public T copy(S source, T target, Class<?> activeJsonView) {
        for (PropertyCopier copier : this.copiers) {
            if (!copier.canCopy(activeJsonView)) continue;
            copier.copy(source, target);
        }
        return target;
    }

    public T copy(S source, Function<S, T> targetSupplier) {
        T target = targetSupplier.apply(source);
        return this.copy(source, target);
    }

    public T copy(S source, Function<S, T> targetSupplier, Class<?> activeJsonView) {
        T target = targetSupplier.apply(source);
        return this.copy(source, target, activeJsonView);
    }

    public PropertyProjector<S, T> add(Method sourceGetter, Method targetSetter) {
        return this.add(sourceGetter, targetSetter, Functions.identity());
    }

    public PropertyProjector<S, T> add(Method sourceGetter, Method targetSetter, Function<?, ?> converter) {
        this.copiers.add(new PropertyCopier(this, t -> {
            try {
                return sourceGetter.invoke(t, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                return null;
            }
        }, (t, u) -> {
            try {
                targetSetter.invoke(t, converter.apply(TypeUtils.cast(u)));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                log.error("Failed to invoke target setter method", (Throwable)e);
            }
        }, JsonViewUtils.findViews(sourceGetter), JsonViewUtils.findViews(targetSetter)));
        return this;
    }

    public <V> PropertyProjector<S, T> add(Method sourceGetter, BiConsumer<T, V> setter) {
        return this.add(this.makeGetter(sourceGetter), setter, Functions.identity(), JsonViewUtils.findViews(sourceGetter));
    }

    public PropertyProjector<S, T> add(String sourcePropertyName, String targetPropertyName) {
        Property getter = BeanMetaUtils.forClass(this.sourceClass).getProperty(sourcePropertyName);
        if (Objects.isNull(getter)) {
            throw new IllegalArgumentException(SOURCE_PROPERTY_NOT_FOUND + sourcePropertyName);
        }
        Property setter = BeanMetaUtils.forClass(this.targetClass).getProperty(targetPropertyName);
        if (Objects.isNull(setter)) {
            throw new IllegalArgumentException("target property not found: " + targetPropertyName);
        }
        return this.add(getter.getReadMethod(), setter.getWriteMethod());
    }

    public PropertyProjector<S, T> add(String sourcePropertyName, String targetPropertyName, Function<?, ?> converter) {
        Property getter = BeanMetaUtils.forClass(this.sourceClass).getProperty(sourcePropertyName);
        if (Objects.isNull(getter)) {
            throw new IllegalArgumentException(SOURCE_PROPERTY_NOT_FOUND + sourcePropertyName);
        }
        Property setter = BeanMetaUtils.forClass(this.targetClass).getProperty(targetPropertyName);
        if (Objects.isNull(setter)) {
            throw new IllegalArgumentException("target property not found: " + targetPropertyName);
        }
        return this.add(getter.getReadMethod(), setter.getWriteMethod(), converter);
    }

    public PropertyProjector<S, T> add(PropertyDescriptor getter, String targetPropertyName, Function<?, ?> converter) {
        Property setter = BeanMetaUtils.forClass(this.targetClass).getProperty(targetPropertyName);
        if (Objects.isNull(setter)) {
            throw new IllegalArgumentException("target property not found: " + targetPropertyName);
        }
        return this.add(getter.getReadMethod(), setter.getWriteMethod(), converter);
    }

    public PropertyProjector<S, T> add(PropertyDescriptor getter, PropertyDescriptor setter, Supplier<Function<?, ?>> converter) {
        return this.add(getter.getReadMethod(), setter.getWriteMethod(), converter.get());
    }

    public PropertyProjector<S, T> add(PropertyDescriptor getter, PropertyDescriptor setter) {
        return this.add(getter.getReadMethod(), setter.getWriteMethod());
    }

    public <V> PropertyProjector<S, T> add(String sourcePropertyName, BiConsumer<T, V> setter) {
        Property getter = BeanMetaUtils.forClass(this.sourceClass).getProperty(sourcePropertyName);
        if (Objects.isNull(getter)) {
            throw new IllegalArgumentException(SOURCE_PROPERTY_NOT_FOUND + sourcePropertyName);
        }
        return this.add(getter.getReadMethod(), setter);
    }

    public <V> PropertyProjector<S, T> add(String sourcePropertyName, BiConsumer<T, V> setter, Function<V, V> converter) {
        Property getter = BeanMetaUtils.forClass(this.sourceClass).getProperty(sourcePropertyName);
        if (Objects.isNull(getter)) {
            throw new IllegalArgumentException(SOURCE_PROPERTY_NOT_FOUND + sourcePropertyName);
        }
        return this.add(this.makeGetter(getter.getReadMethod()), setter, converter, JsonViewUtils.findViews(getter.getReadMethod()));
    }

    public <V> PropertyProjector<S, T> add(Function<S, V> getter, BiConsumer<T, V> setter) {
        this.copiers.add(new PropertyCopier(this, getter, setter));
        return this;
    }

    public <V> PropertyProjector<S, T> add(Function<S, V> getter, BiConsumer<T, V> setter, Class<?> ... views) {
        this.copiers.add(new PropertyCopier(this, getter, setter, views));
        return this;
    }

    public <V> PropertyProjector<S, T> add(Function<S, V> getter, BiConsumer<T, V> setter, Class<?>[] getterViews, Class<?>[] setterViews) {
        this.copiers.add(new PropertyCopier(this, getter, setter, getterViews, setterViews));
        return this;
    }

    public <V> PropertyProjector<S, T> add(Function<S, V> getter, BiConsumer<T, V> setter, Function<V, V> converter) {
        return this.add(getter, (T t, V u) -> setter.accept(t, converter.apply(TypeUtils.cast(u))));
    }

    public <V> PropertyProjector<S, T> add(Function<S, V> getter, BiConsumer<T, V> setter, Function<V, V> converter, Class<?> ... views) {
        if (Objects.isNull(converter)) {
            return this.add(getter, setter, views);
        }
        return this.add(getter, (T t, V u) -> setter.accept(t, converter.apply(TypeUtils.cast(u))), views);
    }

    private <V> Function<S, V> makeGetter(Method readMethod) {
        return s -> {
            try {
                return TypeUtils.cast(readMethod.invoke(s, new Object[0]));
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                throw new IllegalStateException("Failed to invoke getter method: " + readMethod.getName(), e);
            }
        };
    }

    private class PropertyCopier {
        private final Function<S, ?> getter;
        private final BiConsumer<T, ?> setter;
        private final Class<?>[] views;
        private final Class<?>[] getterViews;
        private final Class<?>[] setterViews;

        private PropertyCopier(PropertyProjector propertyProjector, Function<S, ?> getter, BiConsumer<T, ?> setter) {
            this(propertyProjector, getter, setter, null);
        }

        private PropertyCopier(PropertyProjector propertyProjector, Function<S, ?> getter, BiConsumer<T, ?> setter, Class<?>[] views) {
            this.getter = getter;
            this.setter = setter;
            this.views = views;
            this.getterViews = null;
            this.setterViews = null;
        }

        public PropertyCopier(PropertyProjector propertyProjector, Function<S, ?> getter, BiConsumer<T, ?> setter, Class<?>[] getterViews, Class<?>[] setterViews) {
            this.getter = getter;
            this.setter = setter;
            this.views = null;
            this.getterViews = getterViews == null ? null : (Class[])getterViews.clone();
            this.setterViews = setterViews == null ? null : (Class[])setterViews.clone();
        }

        public void copy(S source, T target) {
            this.setter.accept(target, TypeUtils.cast(this.getter.apply(source)));
        }

        public boolean canCopy(Class<?> activeJsonView) {
            if (Objects.isNull(activeJsonView)) {
                return true;
            }
            if (Objects.nonNull(this.views)) {
                return JsonViewUtils.isInView(activeJsonView, this.views);
            }
            return JsonViewUtils.isInView(activeJsonView, this.getterViews) && JsonViewUtils.isInView(activeJsonView, this.setterViews);
        }
    }
}

