/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.projection;

import cn.dinodev.spring.commons.bean.BeanMetaUtils;
import cn.dinodev.spring.commons.context.ContextHelper;
import cn.dinodev.spring.commons.function.Suppliers;
import cn.dinodev.spring.commons.utils.TypeUtils;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.FatalBeanException;
import org.springframework.core.ResolvableType;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;

public final class ProjectionUtils {
    private static final Supplier<ProjectionFactory> PROJECTION_FACTORY_SUPPLIER = Suppliers.lazy(() -> ContextHelper.findBean(ProjectionFactory.class));

    public static ProjectionFactory resolveProjectionFactory() {
        return PROJECTION_FACTORY_SUPPLIER.get();
    }

    public static void projectProperties(Object source, Object target) {
        ProjectionUtils.projectProperties(source, target, null, Collections.emptySet());
    }

    public static void projectProperties(Object source, Object target, Class<?> editable) {
        ProjectionUtils.projectProperties(source, target, editable, Collections.emptySet());
    }

    public static void projectProperties(Object source, Object target, String ... ignoreProperties) {
        Set<String> ignoreList = ignoreProperties != null && ignoreProperties.length > 0 ? Set.of(ignoreProperties) : Collections.emptySet();
        ProjectionUtils.projectProperties(source, target, null, ignoreList);
    }

    private static void projectProperties(Object source, Object target, @Nullable Class<?> editable, Set<String> ignoreProperties) {
        PropertyDescriptor[] targetPds;
        Assert.notNull((Object)source, (String)"Source must not be null");
        Assert.notNull((Object)target, (String)"Target must not be null");
        Class<?> actualEditable = target.getClass();
        if (editable != null) {
            if (!editable.isInstance(target)) {
                throw new IllegalArgumentException("Target class [" + target.getClass().getName() + "] not assignable to Editable class [" + editable.getName() + "]");
            }
            actualEditable = editable;
        }
        for (PropertyDescriptor targetPd : targetPds = BeanUtils.getPropertyDescriptors(actualEditable)) {
            Method writeMethod = targetPd.getWriteMethod();
            PropertyDescriptor sourcePd = BeanUtils.getPropertyDescriptor(source.getClass(), (String)targetPd.getName());
            if (writeMethod == null || ignoreProperties.contains(targetPd.getName()) || sourcePd == null || sourcePd.getReadMethod() == null) continue;
            Method readMethod = sourcePd.getReadMethod();
            try {
                ProjectionUtils.projectProperty(source, target, readMethod, writeMethod);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                throw new FatalBeanException("Could not project property '" + targetPd.getName() + "' from source to target", (Throwable)ex);
            }
        }
    }

    private static void projectProperty(Object source, Object target, Method readMethod, Method writeMethod) throws IllegalAccessException, InvocationTargetException {
        boolean isAssignable;
        ResolvableType sourceResolvableType = ResolvableType.forMethodReturnType((Method)readMethod);
        ResolvableType targetResolvableType = ResolvableType.forMethodParameter((Method)writeMethod, (int)0);
        if (sourceResolvableType.hasUnresolvableGenerics() || targetResolvableType.hasUnresolvableGenerics()) {
            isAssignable = ClassUtils.isAssignable(writeMethod.getParameterTypes()[0], readMethod.getReturnType());
        } else if (targetResolvableType.isAssignableFrom(sourceResolvableType)) {
            isAssignable = true;
        } else {
            Class targetClass = targetResolvableType.getRawClass();
            boolean bl = isAssignable = targetClass != null && BeanUtils.isSimpleValueType((Class)targetClass);
        }
        if (!Modifier.isPublic(readMethod.getDeclaringClass().getModifiers())) {
            readMethod.setAccessible(true);
        }
        if (!Modifier.isPublic(writeMethod.getDeclaringClass().getModifiers())) {
            writeMethod.setAccessible(true);
        }
        if (isAssignable) {
            Object value = readMethod.invoke(source, new Object[0]);
            writeMethod.invoke(target, value);
        } else {
            Object targetValue = ProjectionUtils.newInstance(targetResolvableType, readMethod.invoke(source, new Object[0]));
            writeMethod.invoke(target, targetValue);
        }
    }

    public static void projectPropertiesWithView(Object source, Object target, @Nonnull Class<?> activeView) {
        ProjectionUtils.projectPropertiesWithView(source, target, null, activeView);
    }

    public static void projectPropertiesWithView(Object source, Object target, @Nullable Class<?> editable, @Nonnull Class<?> activeView) {
        Class<?> actualEditable = Objects.nonNull(editable) ? editable : target.getClass();
        HashSet<String> ignoredProperties = new HashSet<String>();
        Object[] unreadableProperties = BeanMetaUtils.forClassWithJsonView(source.getClass(), activeView).getUnreadablePropertyNames();
        CollectionUtils.addAll(ignoredProperties, (Object[])unreadableProperties);
        Object[] unwritableProperties = BeanMetaUtils.forClassWithJsonView(actualEditable, activeView).getUnwritablePropertyNames();
        CollectionUtils.addAll(ignoredProperties, (Object[])unwritableProperties);
        ProjectionUtils.projectProperties(source, target, editable, ignoredProperties);
    }

    private static Object newInstance(ResolvableType type, Object value) {
        if (value == null) {
            return null;
        }
        Class cls = type.resolve();
        if (cls == null || TypeUtils.isPrimitiveOrString(cls)) {
            return value;
        }
        if (cls.isAssignableFrom(List.class)) {
            return ProjectionUtils.newList(type, value);
        }
        if (cls.isAssignableFrom(Map.class)) {
            return ProjectionUtils.newMap(type, value);
        }
        if (cls.isAssignableFrom(Set.class)) {
            return ProjectionUtils.newSet(type, value);
        }
        if (cls.isArray()) {
            return ProjectionUtils.newArray(cls.getComponentType(), value);
        }
        Object target = BeanUtils.instantiateClass((Class)cls);
        ProjectionUtils.projectProperties(value, target);
        return target;
    }

    private static List<?> newList(ResolvableType type, Object value) {
        Collection valueList = (Collection)TypeUtils.castNonNull(value);
        ArrayList<Object> list = new ArrayList<Object>(valueList.size());
        ResolvableType genericCls = type.getGeneric(new int[]{0});
        for (Object item : valueList) {
            if (item == null || genericCls.isAssignableFrom(ResolvableType.forInstance(item))) {
                list.add(item);
                continue;
            }
            list.add(ProjectionUtils.newInstance(genericCls, item));
        }
        return list;
    }

    private static Map<?, ?> newMap(ResolvableType type, Object value) {
        Map valueMap = (Map)TypeUtils.castNonNull(value);
        HashMap map = new HashMap(valueMap.size());
        ResolvableType genericCls = type.getGeneric(new int[]{1});
        for (Map.Entry entry : valueMap.entrySet()) {
            if (genericCls.isAssignableFrom(ResolvableType.forInstance(entry.getValue()))) {
                map.put(entry.getKey(), entry.getValue());
                continue;
            }
            map.put(entry.getKey(), ProjectionUtils.newInstance(genericCls, entry.getValue()));
        }
        return map;
    }

    private static Set<?> newSet(ResolvableType type, Object value) {
        Set valueSet = (Set)TypeUtils.castNonNull(value);
        HashSet<Object> set = new HashSet<Object>(valueSet.size());
        ResolvableType genericCls = type.getGeneric(new int[]{0});
        for (Object item : valueSet) {
            if (genericCls.isAssignableFrom(ResolvableType.forInstance(item))) {
                set.add(item);
                continue;
            }
            set.add(ProjectionUtils.newInstance(genericCls, item));
        }
        return set;
    }

    private static Object newArray(Class<?> componentClass, Object value) {
        Object[] srcArr;
        ResolvableType type = ResolvableType.forClass(componentClass);
        if (ClassUtils.isAssignableValue(Collection.class, (Object)value)) {
            Collection col = (Collection)TypeUtils.castNonNull(value);
            srcArr = col.toArray();
        } else {
            srcArr = (Object[])TypeUtils.castNonNull(value);
        }
        Object[] destArr = (Object[])TypeUtils.castNonNull(Array.newInstance(componentClass, srcArr.length));
        for (int i = 0; i < destArr.length; ++i) {
            Object element = srcArr[i];
            destArr[i] = element == null || type.isAssignableFrom(ResolvableType.forInstance((Object)element)) ? element : ProjectionUtils.newInstance(type, element);
        }
        return destArr;
    }

    @Generated
    private ProjectionUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

