/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.projection;

import cn.dinodev.spring.commons.projection.ProjectionUtils;
import cn.dinodev.spring.commons.utils.TypeUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.projection.ProjectionFactory;
import org.springframework.stereotype.Service;

@Service
public class ProjectionService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProjectionService.class);
    @Autowired
    private ProjectionFactory projectionFactory;

    public <P, R> R projection(Class<R> projectionType, P source) {
        if (Objects.isNull(source)) {
            return null;
        }
        if (projectionType.isInterface()) {
            return (R)this.projectionFactory.createNullableProjection(projectionType, source);
        }
        try {
            R inst = TypeUtils.newInstance(projectionType);
            ProjectionUtils.projectProperties(source, inst);
            return inst;
        }
        catch (IllegalArgumentException | SecurityException | UnsupportedOperationException e) {
            log.error("create instance of {} error", (Object)projectionType.getName(), (Object)e);
            throw new IllegalArgumentException("instance of class: %s cannot be created".formatted(projectionType.getName()), e);
        }
    }

    public <P, R> R projection(Class<R> projectionType, Optional<P> source) {
        return this.projection(projectionType, (P)source.orElse(null));
    }

    public <P, R> List<R> projection(Class<R> projectionType, Collection<P> sourceList) {
        if (CollectionUtils.isEmpty(sourceList)) {
            return Collections.emptyList();
        }
        return sourceList.stream().map(p -> this.projection(projectionType, p)).collect(Collectors.toList());
    }

    public <O, P, R> Map<O, R> projection(Class<R> projectionType, Map<O, P> sourceMap) {
        if (MapUtils.isEmpty(sourceMap)) {
            return Collections.emptyMap();
        }
        HashMap projMap = new HashMap(sourceMap.size());
        sourceMap.entrySet().forEach(e -> projMap.put(e.getKey(), this.projection(projectionType, e.getValue())));
        return projMap;
    }
}

