/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.json;

import com.fasterxml.jackson.annotation.JsonView;
import java.lang.reflect.AnnotatedElement;
import java.util.Objects;
import lombok.Generated;

public final class JsonViewUtils {
    public static boolean isInView(Class<?> activeView, Class<?>[] views) {
        return JsonViewUtils.isInView(activeView, views, true);
    }

    public static boolean isInView(Class<?> activeView, Class<?>[] views, boolean defaultViewInclusion) {
        if (activeView == null) {
            return true;
        }
        if (views == null || views.length == 0) {
            return defaultViewInclusion;
        }
        int len = views.length;
        for (int i = 0; i < len; ++i) {
            if (!views[i].isAssignableFrom(activeView)) continue;
            return true;
        }
        return false;
    }

    public static Class<?>[] findViews(AnnotatedElement element) {
        if (element == null) {
            return new Class[0];
        }
        JsonView viewAnno = element.getDeclaredAnnotation(JsonView.class);
        if (Objects.nonNull(viewAnno)) {
            return viewAnno.value();
        }
        return new Class[0];
    }

    public static boolean isInView(AnnotatedElement element, Class<?> activeView) {
        return JsonViewUtils.isInView(activeView, JsonViewUtils.findViews(element), true);
    }

    public static boolean isInView(AnnotatedElement element, Class<?> activeView, boolean defaultViewInclusion) {
        return JsonViewUtils.isInView(activeView, JsonViewUtils.findViews(element), defaultViewInclusion);
    }

    @Generated
    private JsonViewUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

