/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.json;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.DatabindContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.jsontype.impl.TypeIdResolverBase;
import jakarta.annotation.Nonnull;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.ClassMetadata;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;

public class AnnotionedJsonTypeIdResolver
extends TypeIdResolverBase {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AnnotionedJsonTypeIdResolver.class);
    private final Map<String, Class<?>> idToType = new ConcurrentHashMap();
    private final Map<Class<?>, String> typeToId = new ConcurrentHashMap();
    private static final Map<Class<?>, String> ANNOS_CACHE = new ConcurrentHashMap(32);

    public static <T extends Annotation> void addAnnotion(Class<T> annoClass, Function<T, String> idExtractor, @Nonnull String packageToScan) throws IOException {
        log.info("start scan package {}, to find annotion {}", (Object)packageToScan, (Object)annoClass.getName());
        packageToScan = StringUtils.replace((String)packageToScan, (String)".", (String)"/");
        packageToScan = StringUtils.removeEnd((String)packageToScan, (String)"/");
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        Resource[] classResources = resourcePatternResolver.getResources("classpath*:/" + packageToScan + "/**/*.class");
        CachingMetadataReaderFactory readerfactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        for (Resource resource : classResources) {
            MetadataReader reader = readerfactory.getMetadataReader(resource);
            ClassMetadata clazzMeta = reader.getClassMetadata();
            if (clazzMeta.isAbstract() || clazzMeta.isAnnotation() || clazzMeta.isInterface() || !clazzMeta.isIndependent() || !reader.getAnnotationMetadata().getAnnotations().isDirectlyPresent(annoClass)) continue;
            AnnotionedJsonTypeIdResolver.cacheClass(clazzMeta, annoClass, idExtractor);
        }
    }

    private static <T extends Annotation> void cacheClass(ClassMetadata clazzMeta, Class<T> annoClass, Function<T, String> idExtractor) {
        String classname = clazzMeta.getClassName();
        try {
            Annotation anno;
            Class<?> clazz = Class.forName(classname);
            if (!clazz.isMemberClass() && !clazz.isSynthetic() && (anno = AnnotationUtils.findAnnotation(clazz, annoClass)) != null) {
                ANNOS_CACHE.put(clazz, idExtractor.apply(anno));
            }
        }
        catch (ClassNotFoundException | ExceptionInInitializerError | NoClassDefFoundError e) {
            log.error("class:{} not found", (Object)classname);
        }
    }

    public void init(JavaType bt) {
        ANNOS_CACHE.entrySet().forEach(e -> {
            if (bt.isTypeOrSuperTypeOf((Class)e.getKey())) {
                this.typeToId.put((Class)e.getKey(), (String)e.getValue());
                if (this.idToType.containsKey(e.getValue())) {
                    throw new IllegalStateException("duplicate id:" + (String)e.getValue() + " for " + String.valueOf(e.getKey()) + " AND " + String.valueOf(this.idToType.get(e.getValue())));
                }
                this.idToType.put((String)e.getValue(), (Class)e.getKey());
            }
        });
    }

    public String idFromValue(Object value) {
        return this.typeToId.get(value.getClass());
    }

    public String idFromValueAndType(Object value, Class<?> suggestedType) {
        return this.idFromValue(value);
    }

    public JavaType typeFromId(DatabindContext context, String id) throws IOException {
        if (!this.idToType.containsKey(id)) {
            throw new IllegalStateException("no class found for key:" + id);
        }
        return context.constructType((Type)this.idToType.get(id));
    }

    public JsonTypeInfo.Id getMechanism() {
        return JsonTypeInfo.Id.CUSTOM;
    }
}

