/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.function;

import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import java.util.function.Supplier;

public interface Suppliers {
    public static <T> Supplier<T> ofConst(T value) {
        return () -> value;
    }

    public static <T> Supplier<T> lazy(final Supplier<T> supplier) {
        return new Supplier<T>(){
            private T value;
            private volatile boolean isCached;
            private final ReentrantLock lock = new ReentrantLock();

            @Override
            public T get() {
                if (this.isCached) {
                    return this.value;
                }
                this.lock.lock();
                try {
                    if (!this.isCached) {
                        this.value = supplier.get();
                        if (this.value == null) {
                            throw new IllegalStateException(String.valueOf(supplier) + ".get() returned null");
                        }
                        this.isCached = true;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                return this.value;
            }
        };
    }

    public static <T> Supplier<T> lazyNullable(final Supplier<T> supplier) {
        return new Supplier<T>(){
            private T value;
            private volatile boolean isCached;
            private final ReentrantLock lock = new ReentrantLock();

            @Override
            public T get() {
                if (this.isCached) {
                    return this.value;
                }
                this.lock.lock();
                try {
                    if (!this.isCached) {
                        this.value = supplier.get();
                        this.isCached = true;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                return this.value;
            }
        };
    }

    public static <T> Supplier<T> lazy(final Supplier<T> supplier, final T defaultValue) {
        return new Supplier<T>(){
            private T value;
            private volatile boolean isCached;
            private final ReentrantLock lock = new ReentrantLock();

            @Override
            public T get() {
                if (this.isCached) {
                    return this.value;
                }
                this.lock.lock();
                try {
                    if (!this.isCached) {
                        this.value = supplier.get();
                        this.isCached = true;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                return this.value == null ? defaultValue : this.value;
            }
        };
    }

    public static <T> Supplier<T> lazyPredicatable(final Supplier<T> supplier, final Predicate<T> predicate) {
        return new Supplier<T>(){
            private T value;
            private volatile boolean isCached;
            private final ReentrantLock lock = new ReentrantLock();

            @Override
            public T get() {
                Object currentValue = this.value;
                if (this.isCached && predicate.test(currentValue)) {
                    return currentValue;
                }
                this.lock.lock();
                try {
                    if (!this.isCached || !predicate.test(this.value)) {
                        this.value = supplier.get();
                        this.isCached = true;
                    }
                }
                finally {
                    this.lock.unlock();
                }
                return this.value;
            }
        };
    }
}

