/*
 * Decompiled with CFR 0.152.
 */
package cn.dinodev.spring.commons.function;

import java.util.Collection;
import java.util.function.Predicate;

public interface Predicates {
    public static <T> Predicate<T> and(Collection<Predicate<T>> components) {
        return t -> {
            for (Predicate component : components) {
                if (component.test(t)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> or(Collection<Predicate<T>> components) {
        return t -> {
            for (Predicate component : components) {
                if (!component.test(t)) continue;
                return true;
            }
            return false;
        };
    }

    public static <T> Predicate<T> not(Predicate<T> component) {
        return t -> !component.test(t);
    }

    public static <T> Predicate<T> alwaysTrue() {
        return t -> true;
    }

    public static <T> Predicate<T> alwaysFalse() {
        return t -> false;
    }

    public static <T> Predicate<T> in(Collection<T> values) {
        return values::contains;
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Predicate<Collection<T>> hasAny(T ... values) {
        return t -> {
            for (Comparable value : values) {
                if (!t.contains(value)) continue;
                return true;
            }
            return false;
        };
    }

    @SafeVarargs
    public static <T extends Comparable<T>> Predicate<Collection<T>> hasAll(T ... values) {
        return t -> {
            for (Comparable value : values) {
                if (t.contains(value)) continue;
                return false;
            }
            return true;
        };
    }

    public static <T> Predicate<T> notIn(Collection<T> values) {
        return t -> !values.contains(t);
    }

    public static <T extends CharSequence> Predicate<T> isEmpty() {
        return t -> t == null || t.length() == 0;
    }

    public static <T extends CharSequence> Predicate<T> isNotEmpty() {
        return t -> t != null && t.length() > 0;
    }
}

